/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.lib.internal;

import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.conjure.java.lib.SafeLong;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.utility.Iterate;

final class ConjureSafeLongList
extends AbstractList<SafeLong>
implements RandomAccess {
    private final MutableLongList delegate;

    ConjureSafeLongList(MutableLongList delegate) {
        this.delegate = delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public void add(int index, SafeLong toAdd) {
        this.delegate.addAtIndex(index, toAdd.longValue());
    }

    @Override
    public SafeLong get(int index) {
        return SafeLong.of(this.delegate.get(index));
    }

    @Override
    public boolean addAll(int index, Collection<? extends SafeLong> collection) {
        long[] target = new long[collection.size()];
        Iterate.forEachWithIndex(collection, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each.longValue();
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    @Override
    public SafeLong remove(int index) {
        return SafeLong.of(this.delegate.removeAtIndex(index));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public SafeLong set(int index, SafeLong element) {
        return SafeLong.of(this.delegate.set(index, element.longValue()));
    }

    ConjureSafeLongList asUnmodifiable() {
        return new ConjureSafeLongList(this.delegate.asUnmodifiable());
    }

    @JsonValue
    long[] jacksonSerialize() {
        return this.delegate.toArray();
    }
}

