/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.lib.internal;

import com.palantir.conjure.java.lib.SafeLong;
import com.palantir.conjure.java.lib.internal.ConjureDoubleList;
import com.palantir.conjure.java.lib.internal.ConjureIntegerList;
import com.palantir.conjure.java.lib.internal.ConjureSafeLongList;
import com.palantir.logsafe.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;

public final class ConjureCollections {
    private ConjureCollections() {
    }

    public static <T> List<T> unmodifiableList(List<T> list) {
        if (list instanceof ConjureIntegerList) {
            ConjureIntegerList conjureIntegerList = (ConjureIntegerList)((Object)list);
            return conjureIntegerList.asUnmodifiable();
        }
        if (list instanceof ConjureDoubleList) {
            ConjureDoubleList conjureDoubleList = (ConjureDoubleList)((Object)list);
            return conjureDoubleList.asUnmodifiable();
        }
        if (list instanceof ConjureSafeLongList) {
            ConjureSafeLongList conjureSafeLongList = (ConjureSafeLongList)list;
            return conjureSafeLongList.asUnmodifiable();
        }
        return Collections.unmodifiableList(list);
    }

    public static <T> void addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Preconditions.checkNotNull(elementsToAdd, (String)"elementsToAdd cannot be null");
        if (elementsToAdd instanceof Collection) {
            addTo.addAll((Collection)elementsToAdd);
        } else {
            for (T element : elementsToAdd) {
                addTo.add(element);
            }
        }
    }

    public static <T> void addAllAndCheckNonNull(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Preconditions.checkNotNull(elementsToAdd, (String)"elementsToAdd cannot be null");
        if (elementsToAdd instanceof Collection) {
            Collection collectionElementsToAdd = (Collection)elementsToAdd;
            if (addTo instanceof ArrayList) {
                ((ArrayList)addTo).ensureCapacity(collectionElementsToAdd.size() + addTo.size());
            }
        }
        for (T element : elementsToAdd) {
            Preconditions.checkNotNull(element, (String)"elementsToAdd cannot contain null elements");
            addTo.add(element);
        }
    }

    public static <T> ArrayList<T> newArrayList(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable, (String)"iterable cannot be null");
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return list;
    }

    public static <T> LinkedHashSet<T> newLinkedHashSet(Iterable<? extends T> iterable) {
        Preconditions.checkNotNull(iterable, (String)"iterable cannot be null");
        if (iterable instanceof Collection) {
            return new LinkedHashSet((Collection)iterable);
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T item : iterable) {
            set.add(item);
        }
        return set;
    }

    public static <T> List<T> newList() {
        return new ArrayList();
    }

    public static <T> List<T> newList(Iterable<? extends T> iterable) {
        return ConjureCollections.newArrayList(iterable);
    }

    public static <T> List<T> newNonNullList() {
        return new ArrayList();
    }

    public static <T> List<T> newNonNullList(Iterable<? extends T> iterable) {
        List<T> arrayList = ConjureCollections.newList(iterable);
        for (T item : arrayList) {
            Preconditions.checkNotNull(item, (String)"iterable cannot contain null elements");
        }
        return arrayList;
    }

    public static <T> Set<T> newSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> newSet(Iterable<? extends T> iterable) {
        return ConjureCollections.newLinkedHashSet(iterable);
    }

    public static <T> Set<T> newNonNullSet() {
        return new LinkedHashSet();
    }

    public static <T> Set<T> newNonNullSet(Iterable<? extends T> iterable) {
        Set<T> set = ConjureCollections.newSet(iterable);
        for (T item : set) {
            Preconditions.checkNotNull(item, (String)"iterable cannot contain null elements");
        }
        return set;
    }

    public static List<Double> newNonNullDoubleList() {
        return new ConjureDoubleList((MutableDoubleList)new DoubleArrayList());
    }

    public static List<Double> newNonNullDoubleList(double[] doubles) {
        return new ConjureDoubleList((MutableDoubleList)new DoubleArrayList(doubles));
    }

    public static List<Double> newNonNullDoubleList(Iterable<Double> iterable) {
        ConjureDoubleList doubleList = iterable instanceof Collection ? new ConjureDoubleList((MutableDoubleList)new DoubleArrayList(((Collection)iterable).size())) : new ConjureDoubleList((MutableDoubleList)new DoubleArrayList());
        ConjureCollections.addAll(doubleList, iterable);
        return doubleList;
    }

    public static void addToDoubleList(Collection<Double> addTo, double toAdd) {
        if (addTo instanceof ConjureDoubleList) {
            ConjureDoubleList conjureDoubleList = (ConjureDoubleList)((Object)addTo);
            conjureDoubleList.add(toAdd);
        } else {
            addTo.add(toAdd);
        }
    }

    public static void addAllToDoubleList(Collection<Double> addTo, double[] elementsToAdd) {
        if (addTo instanceof ConjureDoubleList) {
            ConjureDoubleList conjureDoubleList = (ConjureDoubleList)((Object)addTo);
            conjureDoubleList.addAll(elementsToAdd);
        } else {
            for (double el : elementsToAdd) {
                addTo.add(el);
            }
        }
    }

    public static List<Integer> newNonNullIntegerList() {
        return new ConjureIntegerList((MutableIntList)new IntArrayList());
    }

    public static List<Integer> newNonNullIntegerList(int[] ints) {
        return new ConjureIntegerList((MutableIntList)new IntArrayList(ints));
    }

    public static List<Integer> newNonNullIntegerList(Iterable<Integer> iterable) {
        ConjureIntegerList integerList = iterable instanceof Collection ? new ConjureIntegerList((MutableIntList)new IntArrayList(((Collection)iterable).size())) : new ConjureIntegerList((MutableIntList)new IntArrayList());
        ConjureCollections.addAll(integerList, iterable);
        return integerList;
    }

    public static void addToIntegerList(Collection<Integer> addTo, int toAdd) {
        if (addTo instanceof ConjureIntegerList) {
            ConjureIntegerList conjureIntegerList = (ConjureIntegerList)((Object)addTo);
            conjureIntegerList.add(toAdd);
        } else {
            addTo.add(toAdd);
        }
    }

    public static void addAllToIntegerList(Collection<Integer> addTo, int[] elementsToAdd) {
        if (addTo instanceof ConjureIntegerList) {
            ConjureIntegerList conjureIntegerList = (ConjureIntegerList)((Object)addTo);
            conjureIntegerList.addAll(elementsToAdd);
        } else {
            for (int el : elementsToAdd) {
                addTo.add(el);
            }
        }
    }

    public static List<Boolean> newNonNullBooleanList() {
        return ConjureCollections.newNonNullList();
    }

    public static List<Boolean> newNonNullBooleanList(Iterable<Boolean> iterable) {
        return ConjureCollections.newNonNullList(iterable);
    }

    public static List<SafeLong> newNonNullSafeLongList() {
        return new ConjureSafeLongList((MutableLongList)new LongArrayList());
    }

    public static List<SafeLong> newNonNullSafeLongList(Iterable<SafeLong> iterable) {
        ConjureSafeLongList safeLongList = iterable instanceof Collection ? new ConjureSafeLongList((MutableLongList)new LongArrayList(((Collection)iterable).size())) : new ConjureSafeLongList((MutableLongList)new LongArrayList());
        ConjureCollections.addAll(safeLongList, iterable);
        return safeLongList;
    }

    public static void addAllToSafeLongList(Collection<SafeLong> addTo, long[] elementsToAdd) {
        for (long el : elementsToAdd) {
            addTo.add(SafeLong.of(el));
        }
    }
}

