/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.lib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.conjure.java.lib.ImmutableSafeLong;
import com.palantir.logsafe.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public abstract class SafeLong
implements Comparable<SafeLong> {
    private static final long MIN_SAFE_VALUE = -9007199254740991L;
    private static final long MAX_SAFE_VALUE = 0x1FFFFFFFFFFFFFL;

    @JsonValue
    @Value.Parameter
    public abstract long longValue();

    @Value.Check
    protected final void check() {
        Preconditions.checkArgument((-9007199254740991L <= this.longValue() && this.longValue() <= 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0, (String)"number must be safely representable in javascript i.e. lie between -9007199254740991 and 9007199254740991");
    }

    public static SafeLong valueOf(String value) {
        return SafeLong.of(Long.parseLong(value));
    }

    @JsonCreator
    public static SafeLong of(long value) {
        return ImmutableSafeLong.of(value);
    }

    public final String toString() {
        return Long.toString(this.longValue());
    }

    @Override
    public final int compareTo(SafeLong other) {
        return Long.compare(this.longValue(), other.longValue());
    }
}

