/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;

final class WebSecurityHandler
implements HttpHandler {
    private static final String CONTENT_SECURITY_POLICY = "default-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; frame-ancestors 'self';";
    private static final String CONTENT_TYPE_OPTIONS = "nosniff";
    private static final String FRAME_OPTIONS = "sameorigin";
    private static final String XSS_PROTECTION = "1; mode=block";
    private static final String REFERRER_POLICY = "strict-origin-when-cross-origin";
    private static final HttpString HEADER_IE_X_CONTENT_SECURITY_POLICY = HttpString.tryFromString((String)"X-Content-Security-Policy");
    private static final String USER_AGENT_IE_10 = "MSIE 10";
    private static final String USER_AGENT_IE_11 = "rv:11.0";
    private final HttpHandler next;

    WebSecurityHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HeaderMap headers = exchange.getResponseHeaders();
        headers.put(Headers.CONTENT_SECURITY_POLICY, CONTENT_SECURITY_POLICY);
        headers.put(Headers.REFERRER_POLICY, REFERRER_POLICY);
        headers.put(Headers.X_CONTENT_TYPE_OPTIONS, CONTENT_TYPE_OPTIONS);
        headers.put(Headers.X_FRAME_OPTIONS, FRAME_OPTIONS);
        headers.put(Headers.X_XSS_PROTECTION, XSS_PROTECTION);
        String userAgent = exchange.getRequestHeaders().getFirst(Headers.USER_AGENT);
        if (userAgent != null && (userAgent.contains(USER_AGENT_IE_10) || userAgent.contains(USER_AGENT_IE_11))) {
            headers.put(HEADER_IE_X_CONTENT_SECURITY_POLICY, CONTENT_SECURITY_POLICY);
        }
        this.next.handleRequest(exchange);
    }
}

