/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.exceptions.SafeIoException;
import io.undertow.io.BufferWritableOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

final class UnclosableOutputStreams {
    static OutputStream wrap(OutputStream delegate) {
        if (delegate instanceof BufferWritableOutputStream) {
            BufferWritableOutputStream bufferWritableOutputStream = (BufferWritableOutputStream)delegate;
            return new UnclosableBufferWritableOutputStream(delegate, bufferWritableOutputStream);
        }
        return new UnclosableOutputStream(delegate);
    }

    private UnclosableOutputStreams() {
    }

    private static final class UnclosableBufferWritableOutputStream
    extends UnclosableOutputStream
    implements BufferWritableOutputStream {
        private final BufferWritableOutputStream bufferWritable;

        UnclosableBufferWritableOutputStream(OutputStream outputStream, BufferWritableOutputStream bufferWritable) {
            super(outputStream);
            this.bufferWritable = bufferWritable;
        }

        public void write(ByteBuffer[] buffers) throws IOException {
            this.assertOpen();
            this.bufferWritable.write(buffers);
        }

        public void write(ByteBuffer byteBuffer) throws IOException {
            this.assertOpen();
            this.bufferWritable.write(byteBuffer);
        }

        public void transferFrom(FileChannel source) throws IOException {
            this.assertOpen();
            this.bufferWritable.transferFrom(source);
        }
    }

    private static class UnclosableOutputStream
    extends OutputStream {
        private final OutputStream delegate;
        private boolean closeCalled;

        UnclosableOutputStream(OutputStream delegate) {
            this.delegate = (OutputStream)Preconditions.checkNotNull((Object)delegate, (String)"Delegate is required");
        }

        @Override
        public final void write(int value) throws IOException {
            this.assertOpen();
            this.delegate.write(value);
        }

        @Override
        public final void write(byte[] buffer) throws IOException {
            this.assertOpen();
            this.delegate.write(buffer);
        }

        @Override
        public final void write(byte[] buffer, int off, int len) throws IOException {
            this.assertOpen();
            this.delegate.write(buffer, off, len);
        }

        @Override
        public final void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public final void close() {
            this.closeCalled = true;
        }

        protected final void assertOpen() throws IOException {
            if (this.closeCalled) {
                throw new SafeIoException("Stream is closed", new Arg[0]);
            }
        }

        public final String toString() {
            return this.getClass().getSimpleName() + "{" + String.valueOf(this.delegate) + "}";
        }
    }
}

