/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CompileTimeConstant;
import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import java.util.List;

final class FrameworkException
extends RuntimeException
implements SafeLoggable {
    private static final ErrorType UNPROCESSABLE_ENTITY = ErrorType.create((ErrorType.Code)ErrorType.Code.INVALID_ARGUMENT, (String)"Conjure:UnprocessableEntity");
    private static final ErrorType UNSUPPORTED_MEDIA_TYPE = ErrorType.create((ErrorType.Code)ErrorType.Code.INVALID_ARGUMENT, (String)"Conjure:UnsupportedMediaType");
    private final String logMessage;
    private final List<Arg<?>> arguments;
    private final int statusCode;
    private final ErrorType errorType;

    private FrameworkException(String message, ErrorType errorType, int statusCode, Throwable cause, Arg<?> ... args) {
        super(FrameworkException.renderMessage(message, args), cause);
        this.logMessage = message;
        this.arguments = ImmutableList.copyOf((Object[])args);
        this.statusCode = statusCode;
        this.errorType = errorType;
    }

    static FrameworkException unprocessableEntity(@CompileTimeConstant String message, Throwable cause, Arg<?> ... args) {
        return new FrameworkException(message, UNPROCESSABLE_ENTITY, 422, cause, args);
    }

    static FrameworkException unsupportedMediaType(@CompileTimeConstant String message, Arg<?> ... args) {
        return new FrameworkException(message, UNSUPPORTED_MEDIA_TYPE, 415, null, args);
    }

    public String getLogMessage() {
        return this.logMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.arguments;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    ErrorType getErrorType() {
        return this.errorType;
    }

    private static String renderMessage(String message, Arg<?> ... args) {
        if (args.length == 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(message).append(": {");
        for (int i = 0; i < args.length; ++i) {
            Arg<?> arg = args[i];
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(arg.getName()).append("=").append(arg.getValue());
        }
        builder.append("}");
        return builder.toString();
    }
}

