/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.tracing.TagTranslator;
import io.undertow.server.HttpServerExchange;

final class EndpointTagTranslator
implements TagTranslator<HttpServerExchange> {
    private final String serviceName;
    private final String endpointName;
    private final String httpPath;
    private final boolean deprecated;
    private final boolean incubating;

    EndpointTagTranslator(Endpoint endpoint) {
        this.serviceName = endpoint.serviceName();
        this.endpointName = endpoint.name();
        this.httpPath = endpoint.template();
        this.deprecated = endpoint.deprecated().isPresent();
        this.incubating = endpoint.tags().contains("incubating");
    }

    public <T> void translate(TagTranslator.TagAdapter<T> adapter, T target, HttpServerExchange _data) {
        adapter.tag(target, "serviceName", this.serviceName);
        adapter.tag(target, "endpointName", this.endpointName);
        adapter.tag(target, "http.url_details.path", this.httpPath);
        if (this.deprecated) {
            adapter.tag(target, "deprecated", "true");
        }
        if (this.incubating) {
            adapter.tag(target, "incubating", "true");
        }
    }

    public String toString() {
        return "TracedRequestTagTranslator{serviceName='" + this.serviceName + "', endpointName='" + this.endpointName + "', httpPath='" + this.httpPath + "', deprecated=" + this.deprecated + ", incubating=" + this.incubating + "}";
    }
}

