/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.palantir.conjure.java.serialization.ObjectMappers;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.runtime.Encoding;
import com.palantir.conjure.java.undertow.runtime.FrameworkException;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.exceptions.SafeIoException;
import java.io.IOException;

public final class Encodings {
    private Encodings() {
    }

    public static Encoding json() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newServerObjectMapper())){
            private static final String CONTENT_TYPE = "application/json";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }
        };
    }

    public static Encoding cbor() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newCborServerObjectMapper())){
            private static final String CONTENT_TYPE = "application/cbor";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }
        };
    }

    public static Encoding smile() {
        return new AbstractJacksonEncoding(Encodings.configure(ObjectMappers.newSmileServerObjectMapper())){
            private static final String CONTENT_TYPE = "application/x-jackson-smile";

            @Override
            public String getContentType() {
                return CONTENT_TYPE;
            }
        };
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        return mapper.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET}).disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.FLUSH_PASSED_TO_STREAM});
    }

    private static abstract class AbstractJacksonEncoding
    implements Encoding {
        private final ObjectMapper mapper;

        AbstractJacksonEncoding(ObjectMapper mapper) {
            this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (String)"ObjectMapper is required");
        }

        @Override
        public final boolean supportsContentType(String contentType) {
            if (contentType == null) {
                return false;
            }
            String supportedContentType = this.getContentType();
            if (contentType.length() < supportedContentType.length()) {
                return false;
            }
            for (int i = 0; i < supportedContentType.length(); ++i) {
                if (Character.toLowerCase(contentType.charAt(i)) == supportedContentType.charAt(i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final <T> Encoding.Serializer<T> serializer(TypeMarker<T> type) {
            ObjectWriter writer = this.mapper.writerFor(this.mapper.constructType(type.getType()));
            return (value, output) -> {
                Preconditions.checkNotNull((Object)value, (String)"cannot serialize null value");
                writer.writeValue(output, value);
            };
        }

        @Override
        public final <T> Encoding.Deserializer<T> deserializer(TypeMarker<T> type) {
            ObjectReader reader = this.mapper.readerFor(this.mapper.constructType(type.getType()));
            return input -> {
                try {
                    Object value = reader.readValue(input);
                    Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"cannot deserialize a JSON null value");
                    return value;
                }
                catch (JsonMappingException e) {
                    throw FrameworkException.unprocessableEntity("Failed to deserialize request", e, new Arg[]{SafeArg.of((String)"contentType", (Object)this.getContentType()), SafeArg.of((String)"type", (Object)type)});
                }
                catch (StreamConstraintsException e) {
                    throw FrameworkException.unprocessableEntity("Stream constraint violation deserializing request", e, new Arg[]{SafeArg.of((String)"contentType", (Object)this.getContentType()), SafeArg.of((String)"type", (Object)type)});
                }
                catch (JsonParseException | NullPointerException e) {
                    throw new SafeIllegalArgumentException("Failed to parse request due to malformed content", e, new Arg[]{SafeArg.of((String)"contentType", (Object)this.getContentType()), SafeArg.of((String)"type", (Object)type)});
                }
                catch (IOException e) {
                    throw new SafeIoException("Failed to deserialize request", (Throwable)e, new Arg[]{SafeArg.of((String)"contentType", (Object)this.getContentType()), SafeArg.of((String)"type", (Object)type)});
                }
            };
        }
    }
}

