/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.undertow.lib.AsyncRequestProcessing;
import com.palantir.conjure.java.undertow.lib.AuthorizationExtractor;
import com.palantir.conjure.java.undertow.lib.BodySerDe;
import com.palantir.conjure.java.undertow.lib.Contexts;
import com.palantir.conjure.java.undertow.lib.ExceptionHandler;
import com.palantir.conjure.java.undertow.lib.MarkerCallback;
import com.palantir.conjure.java.undertow.lib.PlainSerDe;
import com.palantir.conjure.java.undertow.lib.UndertowRuntime;
import com.palantir.conjure.java.undertow.runtime.ConjureAsyncRequestProcessing;
import com.palantir.conjure.java.undertow.runtime.ConjureAuthorizationExtractor;
import com.palantir.conjure.java.undertow.runtime.ConjureBodySerDe;
import com.palantir.conjure.java.undertow.runtime.ConjureContexts;
import com.palantir.conjure.java.undertow.runtime.ConjureExceptions;
import com.palantir.conjure.java.undertow.runtime.ConjurePlainSerDe;
import com.palantir.conjure.java.undertow.runtime.DefaultRequestArgHandler;
import com.palantir.conjure.java.undertow.runtime.Encoding;
import com.palantir.conjure.java.undertow.runtime.Encodings;
import com.palantir.conjure.java.undertow.runtime.JsonWebTokenHandler;
import com.palantir.conjure.java.undertow.runtime.MarkerCallbacks;
import com.palantir.conjure.java.undertow.runtime.ParamMarker;
import com.palantir.conjure.java.undertow.runtime.RequestArgHandler;
import com.palantir.logsafe.Preconditions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public final class ConjureUndertowRuntime
implements UndertowRuntime {
    private final BodySerDe bodySerDe;
    private final AuthorizationExtractor auth;
    private final MarkerCallback markerCallback;
    private final AsyncRequestProcessing async;
    private final ExceptionHandler exceptionHandler;
    private final Contexts contexts;

    private ConjureUndertowRuntime(Builder builder) {
        this.bodySerDe = new ConjureBodySerDe((List<Encoding>)(builder.encodings.isEmpty() ? ImmutableList.of((Object)Encodings.json(), (Object)Encodings.smile(), (Object)Encodings.cbor()) : builder.encodings));
        this.auth = new ConjureAuthorizationExtractor(this.plainSerDe(), builder.jsonWebTokenHandler);
        this.exceptionHandler = builder.exceptionHandler;
        this.markerCallback = MarkerCallbacks.fold(builder.paramMarkers);
        this.async = new ConjureAsyncRequestProcessing(builder.asyncTimeout, builder.exceptionHandler);
        this.contexts = new ConjureContexts(builder.requestArgHandler);
    }

    public static Builder builder() {
        return new Builder();
    }

    public BodySerDe bodySerDe() {
        return this.bodySerDe;
    }

    public PlainSerDe plainSerDe() {
        return ConjurePlainSerDe.INSTANCE;
    }

    public MarkerCallback markers() {
        return this.markerCallback;
    }

    public AuthorizationExtractor auth() {
        return this.auth;
    }

    public AsyncRequestProcessing async() {
        return this.async;
    }

    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    public Contexts contexts() {
        return this.contexts;
    }

    public static final class Builder {
        private Duration asyncTimeout = Duration.ofMinutes(3L);
        private ExceptionHandler exceptionHandler = ConjureExceptions.INSTANCE;
        private RequestArgHandler requestArgHandler = DefaultRequestArgHandler.INSTANCE;
        private JsonWebTokenHandler jsonWebTokenHandler = (_exchange, _token) -> {};
        private final List<Encoding> encodings = new ArrayList<Encoding>();
        private final List<ParamMarker> paramMarkers = new ArrayList<ParamMarker>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public Builder asyncTimeout(Duration value) {
            this.asyncTimeout = (Duration)Preconditions.checkNotNull((Object)value, (String)"asyncTimeout is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder encodings(Encoding value) {
            this.encodings.add((Encoding)Preconditions.checkNotNull((Object)value, (String)"encoding is required"));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder paramMarker(ParamMarker value) {
            this.paramMarkers.add((ParamMarker)Preconditions.checkNotNull((Object)value, (String)"paramMarker is required"));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder exceptionHandler(ExceptionHandler value) {
            this.exceptionHandler = (ExceptionHandler)Preconditions.checkNotNull((Object)value, (String)"exceptionHandler is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder requestArgHandler(RequestArgHandler value) {
            this.requestArgHandler = (RequestArgHandler)Preconditions.checkNotNull((Object)value, (String)"requestLogParameterHandler is required");
            return this;
        }

        @CanIgnoreReturnValue
        public Builder jsonWebTokenHandler(JsonWebTokenHandler value) {
            this.jsonWebTokenHandler = (JsonWebTokenHandler)Preconditions.checkNotNull((Object)value, (String)"jsonWebTokenHandler is required");
            return this;
        }

        public ConjureUndertowRuntime build() {
            return new ConjureUndertowRuntime(this);
        }
    }
}

