/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.lib.SafeLong;
import com.palantir.conjure.java.undertow.lib.PlainSerDe;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.ri.ResourceIdentifier;
import com.palantir.tokens.auth.BearerToken;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;

enum ConjurePlainSerDe implements PlainSerDe
{
    INSTANCE;


    public BearerToken deserializeBearerToken(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return BearerToken.valueOf((String)in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize bearertoken", (Throwable)ex, new Arg[0]);
        }
    }

    public BearerToken deserializeBearerToken(@Nullable Iterable<String> in) {
        return this.deserializeBearerToken(ConjurePlainSerDe.getOnlyElementDoNotLogValues(in));
    }

    public Optional<BearerToken> deserializeOptionalBearerToken(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeBearerToken(in));
    }

    public Optional<BearerToken> deserializeOptionalBearerToken(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeBearerToken(ConjurePlainSerDe.getOnlyElementDoNotLogValues(in)));
    }

    public List<BearerToken> deserializeBearerTokenList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeBearerToken(item));
        }
        return builder.build();
    }

    public Set<BearerToken> deserializeBearerTokenSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeBearerToken(item));
        }
        return builder.build();
    }

    public boolean deserializeBoolean(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return Boolean.parseBoolean(in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize boolean", (Throwable)ex, new Arg[0]);
        }
    }

    public boolean deserializeBoolean(@Nullable Iterable<String> in) {
        return this.deserializeBoolean(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<Boolean> deserializeOptionalBoolean(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeBoolean(in));
    }

    public Optional<Boolean> deserializeOptionalBoolean(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeBoolean(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<Boolean> deserializeBooleanList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeBoolean(item));
        }
        return builder.build();
    }

    public Set<Boolean> deserializeBooleanSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeBoolean(item));
        }
        return builder.build();
    }

    public OffsetDateTime deserializeDateTime(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return OffsetDateTime.parse(in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize datetime", (Throwable)ex, new Arg[0]);
        }
    }

    public OffsetDateTime deserializeDateTime(@Nullable Iterable<String> in) {
        return this.deserializeDateTime(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<OffsetDateTime> deserializeOptionalDateTime(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeDateTime(in));
    }

    public Optional<OffsetDateTime> deserializeOptionalDateTime(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeDateTime(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<OffsetDateTime> deserializeDateTimeList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeDateTime(item));
        }
        return builder.build();
    }

    public Set<OffsetDateTime> deserializeDateTimeSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeDateTime(item));
        }
        return builder.build();
    }

    public double deserializeDouble(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return Double.parseDouble(in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize double", (Throwable)ex, new Arg[0]);
        }
    }

    public double deserializeDouble(@Nullable Iterable<String> in) {
        return this.deserializeDouble(ConjurePlainSerDe.getOnlyElement(in));
    }

    public OptionalDouble deserializeOptionalDouble(@Nullable String in) {
        if (in == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.deserializeDouble(in));
    }

    public OptionalDouble deserializeOptionalDouble(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(this.deserializeDouble(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<Double> deserializeDoubleList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeDouble(item));
        }
        return builder.build();
    }

    public Set<Double> deserializeDoubleSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeDouble(item));
        }
        return builder.build();
    }

    public int deserializeInteger(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return Integer.parseInt(in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize integer", (Throwable)ex, new Arg[0]);
        }
    }

    public int deserializeInteger(@Nullable Iterable<String> in) {
        return this.deserializeInteger(ConjurePlainSerDe.getOnlyElement(in));
    }

    public OptionalInt deserializeOptionalInteger(@Nullable String in) {
        if (in == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.deserializeInteger(in));
    }

    public OptionalInt deserializeOptionalInteger(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(this.deserializeInteger(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<Integer> deserializeIntegerList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeInteger(item));
        }
        return builder.build();
    }

    public Set<Integer> deserializeIntegerSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeInteger(item));
        }
        return builder.build();
    }

    public ResourceIdentifier deserializeRid(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return ResourceIdentifier.valueOf((String)in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize rid", (Throwable)ex, new Arg[0]);
        }
    }

    public ResourceIdentifier deserializeRid(@Nullable Iterable<String> in) {
        return this.deserializeRid(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<ResourceIdentifier> deserializeOptionalRid(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeRid(in));
    }

    public Optional<ResourceIdentifier> deserializeOptionalRid(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeRid(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<ResourceIdentifier> deserializeRidList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeRid(item));
        }
        return builder.build();
    }

    public Set<ResourceIdentifier> deserializeRidSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeRid(item));
        }
        return builder.build();
    }

    public SafeLong deserializeSafeLong(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return SafeLong.valueOf((String)in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize safelong", (Throwable)ex, new Arg[0]);
        }
    }

    public SafeLong deserializeSafeLong(@Nullable Iterable<String> in) {
        return this.deserializeSafeLong(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<SafeLong> deserializeOptionalSafeLong(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeSafeLong(in));
    }

    public Optional<SafeLong> deserializeOptionalSafeLong(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeSafeLong(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<SafeLong> deserializeSafeLongList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeSafeLong(item));
        }
        return builder.build();
    }

    public Set<SafeLong> deserializeSafeLongSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeSafeLong(item));
        }
        return builder.build();
    }

    public String deserializeString(@Nullable String in) {
        return ConjurePlainSerDe.checkArgumentNotNull(in);
    }

    public String deserializeString(@Nullable Iterable<String> in) {
        return this.deserializeString(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<String> deserializeOptionalString(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeString(in));
    }

    public Optional<String> deserializeOptionalString(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeString(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<String> deserializeStringList(@Nullable Iterable<String> in) {
        return in == null ? Collections.emptyList() : ImmutableList.copyOf(in);
    }

    public Set<String> deserializeStringSet(@Nullable Iterable<String> in) {
        return in == null ? Collections.emptySet() : ImmutableSet.copyOf(in);
    }

    public UUID deserializeUuid(@Nullable String in) {
        ConjurePlainSerDe.checkArgumentNotNull(in);
        try {
            return UUID.fromString(in);
        }
        catch (RuntimeException ex) {
            throw new SafeIllegalArgumentException("failed to deserialize uuid", (Throwable)ex, new Arg[0]);
        }
    }

    public UUID deserializeUuid(@Nullable Iterable<String> in) {
        return this.deserializeUuid(ConjurePlainSerDe.getOnlyElement(in));
    }

    public Optional<UUID> deserializeOptionalUuid(@Nullable String in) {
        if (in == null) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeUuid(in));
    }

    public Optional<UUID> deserializeOptionalUuid(@Nullable Iterable<String> in) {
        if (in == null || Iterables.isEmpty(in)) {
            return Optional.empty();
        }
        return Optional.of(this.deserializeUuid(ConjurePlainSerDe.getOnlyElement(in)));
    }

    public List<UUID> deserializeUuidList(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeUuid(item));
        }
        return builder.build();
    }

    public Set<UUID> deserializeUuidSet(@Nullable Iterable<String> in) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add((Object)this.deserializeUuid(item));
        }
        return builder.build();
    }

    public <T> T deserializeComplex(@Nullable String in, Function<String, T> factory) {
        return factory.apply(this.deserializeString(ConjurePlainSerDe.checkArgumentNotNull(in)));
    }

    public <T> T deserializeComplex(@Nullable Iterable<String> in, Function<String, T> factory) {
        return factory.apply(this.deserializeString(in));
    }

    public <T> Optional<T> deserializeOptionalComplex(@Nullable Iterable<String> in, Function<String, T> factory) {
        return this.deserializeOptionalString(in).map(factory);
    }

    public <T> List<T> deserializeComplexList(@Nullable Iterable<String> in, Function<String, T> factory) {
        if (in == null) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String item : in) {
            builder.add(this.deserializeComplex(item, factory));
        }
        return builder.build();
    }

    public <T> Set<T> deserializeComplexSet(@Nullable Iterable<String> in, Function<String, T> factory) {
        if (in == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String item : in) {
            builder.add(this.deserializeComplex(item, factory));
        }
        return builder.build();
    }

    private static <T> T getOnlyElement(@Nullable Iterable<T> input) {
        return ConjurePlainSerDe.getOnlyElementInternal(input, true);
    }

    private static <T> T getOnlyElementDoNotLogValues(@Nullable Iterable<T> input) {
        return ConjurePlainSerDe.getOnlyElementInternal(input, false);
    }

    private static <T> T getOnlyElementInternal(@Nullable Iterable<T> input, boolean includeValues) {
        if (input == null) {
            throw new SafeIllegalArgumentException("Expected one element but received null", new Arg[0]);
        }
        Iterator<T> iterator = input.iterator();
        if (!iterator.hasNext()) {
            throw new SafeIllegalArgumentException("Expected one element but received none", new Arg[0]);
        }
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        int size = Iterables.size(input);
        if (includeValues) {
            throw new SafeIllegalArgumentException("Expected one element", new Arg[]{SafeArg.of((String)"size", (Object)size), UnsafeArg.of((String)"received", input)});
        }
        throw new SafeIllegalArgumentException("Expected one element", new Arg[]{SafeArg.of((String)"size", (Object)size)});
    }

    @CanIgnoreReturnValue
    private static <T> T checkArgumentNotNull(@Nullable T input) {
        if (input == null) {
            throw new SafeIllegalArgumentException("Value is required", new Arg[0]);
        }
        return input;
    }
}

