/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.palantir.conjure.java.undertow.lib.Contexts;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.RequestContext;
import com.palantir.conjure.java.undertow.runtime.RequestArgHandler;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

final class ConjureContexts
implements Contexts {
    private static final SafeLogger log = SafeLoggerFactory.get(ConjureContexts.class);
    private final RequestArgHandler requestArgHandler;

    ConjureContexts(RequestArgHandler requestArgHandler) {
        this.requestArgHandler = requestArgHandler;
    }

    public RequestContext createContext(HttpServerExchange exchange, Endpoint _endpoint) {
        return new ConjureServerRequestContext(exchange, this.requestArgHandler);
    }

    private static final class ConjureServerRequestContext
    implements RequestContext {
        private final HttpServerExchange exchange;
        private final RequestArgHandler requestArgHandler;
        private ImmutableListMultimap<String, String> cachedQueryParams;

        ConjureServerRequestContext(HttpServerExchange exchange, RequestArgHandler requestArgHandler) {
            this.exchange = exchange;
            this.requestArgHandler = requestArgHandler;
        }

        public String requestTarget() {
            String requestUri = this.exchange.getRequestURI();
            String queryString = this.exchange.getQueryString();
            return Strings.isNullOrEmpty((String)queryString) ? requestUri : requestUri + "?" + queryString;
        }

        public List<String> header(String headerName) {
            HeaderValues header = this.exchange.getRequestHeaders().get(headerName);
            return header == null ? ImmutableList.of() : Collections.unmodifiableList(header);
        }

        public Optional<String> firstHeader(String headerName) {
            return Optional.ofNullable(this.exchange.getRequestHeaders().getFirst(headerName));
        }

        public Optional<String> cookie(String cookieName) {
            return Optional.ofNullable(this.exchange.getRequestCookie(cookieName)).map(Cookie::getValue);
        }

        public ImmutableListMultimap<String, String> queryParameters() {
            ImmutableListMultimap<String, String> cachedQueryParamsSnapshot = this.cachedQueryParams;
            if (cachedQueryParamsSnapshot == null) {
                this.cachedQueryParams = cachedQueryParamsSnapshot = this.buildQueryParameters();
            }
            return cachedQueryParamsSnapshot;
        }

        public void requestArg(Arg<?> arg) {
            this.requestArgHandler.arg(this.exchange, arg);
        }

        public ImmutableList<Certificate> peerCertificates() {
            SSLSession sslSession = this.exchange.getConnection().getSslSession();
            if (sslSession != null) {
                try {
                    return ImmutableList.copyOf((Object[])sslSession.getPeerCertificates());
                }
                catch (SSLPeerUnverifiedException e) {
                    log.debug("Failed to extract peer certificates", (Throwable)e);
                }
            }
            return ImmutableList.of();
        }

        private ImmutableListMultimap<String, String> buildQueryParameters() {
            Map rawQueryParameters = this.exchange.getQueryParameters();
            if (rawQueryParameters.isEmpty()) {
                return ImmutableListMultimap.of();
            }
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            this.exchange.getQueryParameters().forEach((arg_0, arg_1) -> ((ImmutableListMultimap.Builder)builder).putAll(arg_0, arg_1));
            return builder.build();
        }

        public String toString() {
            return "ConjureServerRequestContext{exchange=" + String.valueOf(this.exchange) + "}";
        }
    }
}

