/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.palantir.conjure.java.undertow.lib.BinaryResponseBody;
import com.palantir.conjure.java.undertow.lib.BodySerDe;
import com.palantir.conjure.java.undertow.lib.Deserializer;
import com.palantir.conjure.java.undertow.lib.Endpoint;
import com.palantir.conjure.java.undertow.lib.Serializer;
import com.palantir.conjure.java.undertow.lib.TypeMarker;
import com.palantir.conjure.java.undertow.runtime.Encoding;
import com.palantir.conjure.java.undertow.runtime.FrameworkException;
import com.palantir.conjure.java.undertow.runtime.LazilyInitializedEncoding;
import com.palantir.conjure.java.undertow.runtime.TracedEncoding;
import com.palantir.conjure.java.undertow.runtime.TypeMarkers;
import com.palantir.conjure.java.undertow.runtime.UnclosableOutputStreams;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tracing.CloseableTracer;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.Tracer;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.Protocols;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.xnio.IoUtils;

final class ConjureBodySerDe
implements BodySerDe {
    private static final SafeLogger log = SafeLoggerFactory.get(ConjureBodySerDe.class);
    private static final String BINARY_CONTENT_TYPE = "application/octet-stream";
    private static final Splitter ACCEPT_VALUE_SPLITTER = Splitter.on((char)',').trimResults().omitEmptyStrings();
    private final List<Encoding> encodings;

    ConjureBodySerDe(List<Encoding> encodings) {
        this.encodings = (List)encodings.stream().map(LazilyInitializedEncoding::new).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((encodings.size() > 0 ? 1 : 0) != 0, (String)"At least one Encoding is required");
    }

    public <T> Serializer<T> serializer(TypeMarker<T> token) {
        return new EncodingSerializerRegistry<T>(this.encodings, token, Optional.empty());
    }

    public <T> Serializer<T> serializer(TypeMarker<T> token, Endpoint endpoint) {
        return new EncodingSerializerRegistry<T>(this.encodings, token, Optional.of(endpoint));
    }

    public <T> Deserializer<T> deserializer(TypeMarker<T> token) {
        return new EncodingDeserializerRegistry<T>(this.encodings, token, Optional.empty());
    }

    public <T> Deserializer<T> deserializer(TypeMarker<T> token, Endpoint endpoint) {
        return new EncodingDeserializerRegistry<T>(this.encodings, token, Optional.of(endpoint));
    }

    public void serialize(BinaryResponseBody value, HttpServerExchange exchange) throws IOException {
        Preconditions.checkNotNull((Object)value, (String)"A BinaryResponseBody value is required");
        exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, BINARY_CONTENT_TYPE);
        Tracer.fastStartSpan((String)"Undertow: serialize");
        try {
            value.write(UnclosableOutputStreams.wrap(exchange.getOutputStream()));
        }
        finally {
            Tracer.fastCompleteSpan((TagTranslator)SerializeBinaryTagTranslator.INSTANCE, (Object)((Object)SerializeBinaryTagTranslator.INSTANCE));
        }
    }

    public InputStream deserializeInputStream(HttpServerExchange exchange) {
        String contentType = ConjureBodySerDe.getContentType(exchange);
        if (contentType.length() < BINARY_CONTENT_TYPE.length() || !contentType.regionMatches(true, 0, BINARY_CONTENT_TYPE, 0, BINARY_CONTENT_TYPE.length())) {
            throw FrameworkException.unsupportedMediaType("Unsupported Content-Type", new Arg[]{SafeArg.of((String)"Content-Type", (Object)contentType)});
        }
        return exchange.getInputStream();
    }

    private static void safelyDrainRequestBody(HttpServerExchange exchange) {
        if ((Protocols.HTTP_1_1.equals(exchange.getProtocol()) || Protocols.HTTP_1_0.equals(exchange.getProtocol())) && !exchange.isRequestComplete()) {
            try (CloseableTracer ignored = CloseableTracer.startSpan((String)"Undertow: drain request body");){
                IoUtils.safeClose((Closeable)exchange.getInputStream());
            }
        }
    }

    private static String getContentType(HttpServerExchange exchange) {
        HeaderValues contentTypeValues = exchange.getRequestHeaders().get(Headers.CONTENT_TYPE);
        if (contentTypeValues == null || contentTypeValues.isEmpty()) {
            throw new SafeIllegalArgumentException("Request is missing Content-Type header", new Arg[0]);
        }
        if (contentTypeValues.size() != 1) {
            log.warn("Request has too many Content-Type headers", (Arg)SafeArg.of((String)"contentTypes", (Object)ImmutableList.copyOf((Collection)contentTypeValues)));
            return contentTypeValues.getFirst();
        }
        return contentTypeValues.get(0);
    }

    private static final class EncodingSerializerRegistry<T>
    implements Serializer<T> {
        private final EncodingSerializerContainer<T> defaultEncoding;
        private final List<EncodingSerializerContainer<T>> encodings;

        EncodingSerializerRegistry(List<Encoding> encodings, TypeMarker<T> token, Optional<Endpoint> endpoint) {
            this.encodings = (List)encodings.stream().map(encoding -> new EncodingSerializerContainer((Encoding)encoding, token, endpoint)).collect(ImmutableList.toImmutableList());
            this.defaultEncoding = this.encodings.get(0);
        }

        public void serialize(T value, HttpServerExchange exchange) throws IOException {
            Preconditions.checkNotNull(value, (String)"cannot serialize null value");
            ConjureBodySerDe.safelyDrainRequestBody(exchange);
            EncodingSerializerContainer<T> container = this.getResponseSerializer(exchange);
            exchange.getResponseHeaders().put(Headers.CONTENT_TYPE, container.encoding.getContentType());
            container.serializer.serialize(value, exchange.getOutputStream());
        }

        EncodingSerializerContainer<T> getResponseSerializer(HttpServerExchange exchange) {
            HeaderValues acceptValues = exchange.getRequestHeaders().get(Headers.ACCEPT);
            if (acceptValues != null) {
                for (int i = 0; i < acceptValues.size(); ++i) {
                    for (String acceptValue : ACCEPT_VALUE_SPLITTER.split((CharSequence)acceptValues.get(i))) {
                        for (int j = 0; j < this.encodings.size(); ++j) {
                            EncodingSerializerContainer<T> container = this.encodings.get(j);
                            if (!container.encoding.supportsContentType(acceptValue)) continue;
                            return container;
                        }
                    }
                }
            }
            return this.defaultEncoding;
        }
    }

    private static final class EncodingDeserializerRegistry<T>
    implements Deserializer<T> {
        private final List<EncodingDeserializerContainer<T>> encodings;
        private final boolean optionalType;
        private final TypeMarker<T> marker;

        EncodingDeserializerRegistry(List<Encoding> encodings, TypeMarker<T> token, Optional<Endpoint> endpoint) {
            this.encodings = (List)encodings.stream().map(encoding -> new EncodingDeserializerContainer((Encoding)encoding, token, endpoint)).collect(ImmutableList.toImmutableList());
            this.optionalType = TypeMarkers.isOptional(token);
            this.marker = token;
        }

        public T deserialize(HttpServerExchange exchange) throws IOException {
            if (this.optionalType && EncodingDeserializerRegistry.maybeEmptyBody(exchange)) {
                return this.deserializeOptional(exchange);
            }
            return this.deserializeInternal(exchange, exchange.getInputStream());
        }

        private T deserializeOptional(HttpServerExchange exchange) throws IOException {
            PushbackInputStream requestStream = new PushbackInputStream(exchange.getInputStream(), 1);
            int firstByte = requestStream.read();
            if (firstByte == -1) {
                return TypeMarkers.getEmptyOptional(this.marker);
            }
            requestStream.unread(firstByte);
            return this.deserializeInternal(exchange, requestStream);
        }

        private T deserializeInternal(HttpServerExchange exchange, InputStream requestStream) throws IOException {
            EncodingDeserializerContainer<T> container = this.getRequestDeserializer(exchange);
            return container.deserializer.deserialize(requestStream);
        }

        private static boolean maybeEmptyBody(HttpServerExchange exchange) {
            String contentLength = exchange.getRequestHeaders().getFirst(Headers.CONTENT_LENGTH);
            return contentLength == null || "0".equals(contentLength);
        }

        EncodingDeserializerContainer<T> getRequestDeserializer(HttpServerExchange exchange) {
            String contentType = ConjureBodySerDe.getContentType(exchange);
            for (int i = 0; i < this.encodings.size(); ++i) {
                EncodingDeserializerContainer<T> container = this.encodings.get(i);
                if (!container.encoding.supportsContentType(contentType)) continue;
                return container;
            }
            throw FrameworkException.unsupportedMediaType("Unsupported Content-Type", new Arg[]{SafeArg.of((String)"Content-Type", (Object)contentType)});
        }
    }

    private static enum SerializeBinaryTagTranslator implements TagTranslator<Object>
    {
        INSTANCE;


        public <T> void translate(TagTranslator.TagAdapter<T> adapter, T target, Object _data) {
            adapter.tag(target, "type", "BinaryResponseBody");
            adapter.tag(target, "contentType", ConjureBodySerDe.BINARY_CONTENT_TYPE);
        }
    }

    private static final class EncodingDeserializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Deserializer<T> deserializer;

        EncodingDeserializerContainer(Encoding encoding, TypeMarker<T> token, Optional<Endpoint> endpoint) {
            this.encoding = encoding;
            this.deserializer = endpoint.isPresent() ? TracedEncoding.wrap(encoding).deserializer(token, endpoint.get()) : TracedEncoding.wrap(encoding).deserializer(token);
        }
    }

    private static final class EncodingSerializerContainer<T> {
        private final Encoding encoding;
        private final Encoding.Serializer<T> serializer;

        EncodingSerializerContainer(Encoding encoding, TypeMarker<T> token, Optional<Endpoint> endpoint) {
            this.encoding = encoding;
            this.serializer = endpoint.isPresent() ? TracedEncoding.wrap(encoding).serializer(token, endpoint.get()) : TracedEncoding.wrap(encoding).serializer(token);
        }
    }
}

