/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.conjure.java.undertow.lib.AsyncRequestProcessing;
import com.palantir.conjure.java.undertow.lib.ExceptionHandler;
import com.palantir.conjure.java.undertow.lib.ReturnValueWriter;
import com.palantir.conjure.java.undertow.runtime.SafeExchangeCompletionListener;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.tracing.DeferredTracer;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.xnio.XnioExecutor;

final class ConjureAsyncRequestProcessing
implements AsyncRequestProcessing {
    private static final Executor DIRECT_EXECUTOR = MoreExecutors.directExecutor();
    private static final boolean INTERRUPT_ON_CANCEL = false;
    private static final AttachmentKey<ListenableFuture<?>> FUTURE = AttachmentKey.create(ListenableFuture.class);
    private static final AttachmentKey<Boolean> TIMED_OUT = AttachmentKey.create(Boolean.class);
    private static final ErrorType ASYNC_REQUEST_PROCESSING_TIMEOUT = ErrorType.create((ErrorType.Code)ErrorType.Code.TIMEOUT, (String)"Conjure:AsyncRequestProcessingTimeout");
    private static final ExchangeCompletionListener COMPLETION_LISTENER = SafeExchangeCompletionListener.of(exchange -> {
        ListenableFuture future = (ListenableFuture)exchange.getAttachment(FUTURE);
        if (future != null) {
            future.cancel(false);
        }
    });
    private final Duration timeout;
    private final ExceptionHandler exceptionHandler;

    ConjureAsyncRequestProcessing(Duration timeout, ExceptionHandler exceptionHandler) {
        this.timeout = timeout;
        this.exceptionHandler = exceptionHandler;
    }

    public <T> void register(ListenableFuture<T> future, ReturnValueWriter<T> returnValueWriter, HttpServerExchange exchange) throws IOException {
        Preconditions.checkNotNull(future, (String)"future");
        Preconditions.checkNotNull(returnValueWriter, (String)"returnValueWriter");
        Preconditions.checkNotNull((Object)exchange, (String)"exchange");
        this.register(future, returnValueWriter, this.timeout, exchange);
    }

    public <T> void register(ListenableFuture<T> future, ReturnValueWriter<T> returnValueWriter, Duration requestAsyncTimeout, HttpServerExchange exchange) throws IOException {
        Preconditions.checkNotNull(future, (String)"future");
        Preconditions.checkNotNull(returnValueWriter, (String)"returnValueWriter");
        Preconditions.checkNotNull((Object)requestAsyncTimeout, (String)"timeout");
        Preconditions.checkNotNull((Object)exchange, (String)"exchange");
        if (future.isDone()) {
            this.writeCompleteFuture(future, returnValueWriter, exchange);
        } else {
            this.registerCallback(future, returnValueWriter, requestAsyncTimeout, exchange);
        }
    }

    private <T> void writeCompleteFuture(ListenableFuture<T> future, ReturnValueWriter<T> returnValueWriter, HttpServerExchange exchange) throws IOException {
        try {
            Object result = Futures.getDone(future);
            returnValueWriter.write(result, exchange);
        }
        catch (ExecutionException e) {
            this.exceptionHandler.handle(exchange, e.getCause());
        }
        catch (RuntimeException e) {
            this.exceptionHandler.handle(exchange, (Throwable)e);
        }
    }

    private <T> void registerCallback(ListenableFuture<T> future, final ReturnValueWriter<T> returnValueWriter, final Duration requestAsyncTimeout, final HttpServerExchange exchange) {
        exchange.putAttachment(FUTURE, future);
        if (exchange.isComplete()) {
            future.cancel(false);
        } else {
            exchange.addExchangeCompleteListener(COMPLETION_LISTENER);
        }
        XnioExecutor.Key timeoutKey = exchange.getIoThread().executeAfter(() -> {
            exchange.putAttachment(TIMED_OUT, (Object)true);
            future.cancel(false);
        }, requestAsyncTimeout.toMillis(), TimeUnit.MILLISECONDS);
        future.addListener(() -> ((XnioExecutor.Key)timeoutKey).remove(), DIRECT_EXECUTOR);
        final DeferredTracer tracer = new DeferredTracer("Undertow: Async Result");
        exchange.dispatch(() -> Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                exchange.dispatch(ConjureAsyncRequestProcessing.this.wrapCallback(_serverExchange -> returnValueWriter.write(result, exchange), tracer));
            }

            public void onFailure(Throwable throwable) {
                exchange.dispatch(ConjureAsyncRequestProcessing.this.wrapCallback(serverExchange -> ConjureAsyncRequestProcessing.this.exceptionHandler.handle(serverExchange, ConjureAsyncRequestProcessing.getThrowable(serverExchange, throwable, requestAsyncTimeout)), tracer));
            }
        }, (Executor)DIRECT_EXECUTOR));
    }

    private static Throwable getThrowable(HttpServerExchange exchange, Throwable failure, Duration timeout) {
        if (failure instanceof CancellationException && Boolean.TRUE.equals(exchange.getAttachment(TIMED_OUT))) {
            return new ServiceException(ASYNC_REQUEST_PROCESSING_TIMEOUT, failure, new Arg[]{SafeArg.of((String)"timeoutSeconds", (Object)timeout.getSeconds())});
        }
        return failure;
    }

    private HttpHandler wrapCallback(HttpHandler action, DeferredTracer tracer) {
        return exchange -> tracer.withTrace(() -> {
            try {
                action.handleRequest(exchange);
            }
            catch (Throwable t) {
                this.exceptionHandler.handle(exchange, t);
            }
            return null;
        });
    }
}

