/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.undertow.runtime;

import com.google.common.base.Strings;
import com.palantir.tracing.TagTranslator;
import com.palantir.tracing.undertow.TracingAttachments;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;

enum CompletedRequestTagTranslator implements TagTranslator<HttpServerExchange>
{
    INSTANCE;

    private static final HttpString FETCH_USER_AGENT;

    public <T> void translate(TagTranslator.TagAdapter<T> adapter, T target, HttpServerExchange exchange) {
        String agent;
        String maybeRequestId = (String)exchange.getAttachment(TracingAttachments.REQUEST_ID);
        if (maybeRequestId != null) {
            adapter.tag(target, "http.request_id", maybeRequestId);
        }
        if (!Strings.isNullOrEmpty((String)(agent = CompletedRequestTagTranslator.conjureUserAgent(exchange)))) {
            adapter.tag(target, "http.useragent", agent);
        }
        adapter.tag(target, "http.status_code", CompletedRequestTagTranslator.statusString(exchange.getStatusCode()));
        adapter.tag(target, "http.method", exchange.getRequestMethod().toString());
        adapter.tag(target, "http.url_details.scheme", exchange.getRequestScheme());
        adapter.tag(target, "http.version", exchange.getProtocol().toString());
        adapter.tag(target, "network.bytes_written", Long.toString(exchange.getResponseBytesSent()));
        long requestContentLength = exchange.getRequestContentLength();
        if (requestContentLength >= 0L) {
            adapter.tag(target, "network.bytes_read", Long.toString(requestContentLength));
        }
    }

    static String statusString(int statusCode) {
        switch (statusCode) {
            case 200: {
                return "200";
            }
            case 204: {
                return "204";
            }
        }
        return Integer.toString(statusCode);
    }

    static String conjureUserAgent(HttpServerExchange exchange) {
        HeaderMap requestHeaders = exchange.getRequestHeaders();
        String fetchUserAgent = requestHeaders.getFirst(FETCH_USER_AGENT);
        return Strings.isNullOrEmpty((String)fetchUserAgent) ? requestHeaders.getFirst(Headers.USER_AGENT) : fetchUserAgent;
    }

    static {
        FETCH_USER_AGENT = HttpString.tryFromString((String)"Fetch-User-Agent");
    }
}

