/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.api.config.service.ImmutableServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.logsafe.DoNotLog;
import com.palantir.tokens.auth.BearerToken;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@DoNotLog
@JsonDeserialize(as=ImmutableServiceConfiguration.class)
@Value.Immutable
public interface ServiceConfiguration {
    @Value.Redacted
    public Optional<BearerToken> apiToken();

    public SslConfiguration security();

    public List<String> uris();

    public Optional<Duration> connectTimeout();

    public Optional<Duration> readTimeout();

    public Optional<Duration> writeTimeout();

    public Optional<Integer> maxNumRetries();

    public Optional<Duration> backoffSlotSize();

    public Optional<Boolean> enableGcmCipherSuites();

    public Optional<Boolean> enableHttp2();

    public Optional<Boolean> fallbackToCommonNameVerification();

    public Optional<ProxyConfiguration> proxy();

    public static ImmutableServiceConfiguration.Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableServiceConfiguration.Builder {
    }
}

