/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.palantir.conjure.java.api.config.service.HumanReadableDuration;
import com.palantir.conjure.java.api.config.service.ImmutablePartialServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.logsafe.DoNotLog;
import com.palantir.tokens.auth.BearerToken;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@DoNotLog
@JsonSerialize(as=ImmutablePartialServiceConfiguration.class)
@JsonDeserialize(builder=Builder.class)
@Value.Immutable
public interface PartialServiceConfiguration {
    @JsonAlias(value={"api-token"})
    @Value.Redacted
    public Optional<BearerToken> apiToken();

    public Optional<SslConfiguration> security();

    public List<String> uris();

    @JsonAlias(value={"connect-timeout"})
    public Optional<HumanReadableDuration> connectTimeout();

    @JsonAlias(value={"read-timeout"})
    public Optional<HumanReadableDuration> readTimeout();

    @JsonAlias(value={"write-timeout"})
    public Optional<HumanReadableDuration> writeTimeout();

    @JsonAlias(value={"max-num-retries"})
    public Optional<Integer> maxNumRetries();

    @JsonAlias(value={"backoff-slot-size"})
    public Optional<HumanReadableDuration> backoffSlotSize();

    @JsonAlias(value={"enable-gcm-cipher-suites"})
    public Optional<Boolean> enableGcmCipherSuites();

    @JsonAlias(value={"enable-http2"})
    public Optional<Boolean> enableHttp2();

    @Deprecated
    @JsonAlias(value={"fallback-to-common-name-verification"})
    public Optional<Boolean> fallbackToCommonNameVerification();

    @JsonAlias(value={"proxy-configuration"})
    public Optional<ProxyConfiguration> proxyConfiguration();

    public static PartialServiceConfiguration of(List<String> uris, Optional<SslConfiguration> sslConfig) {
        return PartialServiceConfiguration.builder().uris(uris).security(sslConfig).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutablePartialServiceConfiguration.Builder {
    }
}

