/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.config.service.UserAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="UserAgent", generator="Immutables")
final class ImmutableUserAgent
implements UserAgent {
    private final UserAgent.Agent primary;
    private final List<UserAgent.Agent> informational;
    private volatile transient long lazyInitBitmap;
    private static final long NODE_ID_LAZY_INIT_BIT = 1L;
    private transient Optional<String> nodeId;

    private ImmutableUserAgent(UserAgent.Agent primary, List<UserAgent.Agent> informational) {
        this.primary = primary;
        this.informational = informational;
    }

    @Override
    public UserAgent.Agent primary() {
        return this.primary;
    }

    @Override
    public List<UserAgent.Agent> informational() {
        return this.informational;
    }

    public final ImmutableUserAgent withPrimary(UserAgent.Agent value) {
        if (this.primary == value) {
            return this;
        }
        UserAgent.Agent newValue = Objects.requireNonNull(value, "primary");
        return new ImmutableUserAgent(newValue, this.informational);
    }

    public final ImmutableUserAgent withInformational(UserAgent.Agent ... elements) {
        List<UserAgent.Agent> newValue = ImmutableUserAgent.createUnmodifiableList(false, ImmutableUserAgent.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableUserAgent(this.primary, newValue);
    }

    public final ImmutableUserAgent withInformational(Iterable<? extends UserAgent.Agent> elements) {
        if (this.informational == elements) {
            return this;
        }
        List<UserAgent.Agent> newValue = ImmutableUserAgent.createUnmodifiableList(false, ImmutableUserAgent.createSafeList(elements, true, false));
        return new ImmutableUserAgent(this.primary, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableUserAgent && this.equalsByValue((ImmutableUserAgent)another);
    }

    private boolean equalsByValue(ImmutableUserAgent another) {
        return this.primary.equals(another.primary) && this.informational.equals(another.informational);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.primary.hashCode();
        h += (h << 5) + this.informational.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UserAgent{");
        builder.append("primary=").append(this.primary);
        builder.append(", ");
        builder.append("informational=").append(this.informational);
        return builder.append("}").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> nodeId() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableUserAgent immutableUserAgent = this;
            synchronized (immutableUserAgent) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.nodeId = Objects.requireNonNull(UserAgent.super.nodeId(), "nodeId");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.nodeId;
    }

    public static UserAgent copyOf(UserAgent instance) {
        if (instance instanceof ImmutableUserAgent) {
            return (ImmutableUserAgent)instance;
        }
        return ImmutableUserAgent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UserAgent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_PRIMARY = 1L;
        private long initBits = 1L;
        private UserAgent.Agent primary;
        private List<UserAgent.Agent> informational = new ArrayList<UserAgent.Agent>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UserAgent instance) {
            Objects.requireNonNull(instance, "instance");
            this.primary(instance.primary());
            this.addAllInformational(instance.informational());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder primary(UserAgent.Agent primary) {
            this.primary = Objects.requireNonNull(primary, "primary");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInformational(UserAgent.Agent element) {
            this.informational.add(Objects.requireNonNull(element, "informational element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addInformational(UserAgent.Agent ... elements) {
            for (UserAgent.Agent element : elements) {
                this.informational.add(Objects.requireNonNull(element, "informational element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder informational(Iterable<? extends UserAgent.Agent> elements) {
            this.informational.clear();
            return this.addAllInformational(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllInformational(Iterable<? extends UserAgent.Agent> elements) {
            for (UserAgent.Agent agent : elements) {
                this.informational.add(Objects.requireNonNull(agent, "informational element"));
            }
            return this;
        }

        public UserAgent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableUserAgent(this.primary, ImmutableUserAgent.createUnmodifiableList(true, this.informational));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("primary");
            }
            return "Cannot build UserAgent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

