/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.config.service.HumanReadableDuration;
import com.palantir.conjure.java.api.config.service.PartialServiceConfiguration;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.service.ServicesConfigBlock;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.tokens.auth.BearerToken;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ServicesConfigBlock", generator="Immutables")
final class ImmutableServicesConfigBlock
extends ServicesConfigBlock {
    private final BearerToken defaultApiToken;
    private final SslConfiguration defaultSecurity;
    private final Map<String, PartialServiceConfiguration> services;
    private final ProxyConfiguration defaultProxyConfiguration;
    private final HumanReadableDuration defaultConnectTimeout;
    private final HumanReadableDuration defaultReadTimeout;
    private final HumanReadableDuration defaultWriteTimeout;
    private final HumanReadableDuration defaultBackoffSlotSize;
    private final Boolean defaultEnableGcmCipherSuites;
    private final Boolean defaultEnableHttp2;
    private final Boolean defaultFallbackToCommonNameVerification;
    private static final ImmutableServicesConfigBlock INSTANCE = ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock());

    private ImmutableServicesConfigBlock() {
        this.defaultApiToken = null;
        this.defaultSecurity = null;
        this.services = Collections.emptyMap();
        this.defaultProxyConfiguration = null;
        this.defaultConnectTimeout = null;
        this.defaultReadTimeout = null;
        this.defaultWriteTimeout = null;
        this.defaultBackoffSlotSize = null;
        this.defaultEnableGcmCipherSuites = null;
        this.defaultEnableHttp2 = null;
        this.defaultFallbackToCommonNameVerification = null;
    }

    private ImmutableServicesConfigBlock(BearerToken defaultApiToken, SslConfiguration defaultSecurity, Map<String, PartialServiceConfiguration> services, ProxyConfiguration defaultProxyConfiguration, HumanReadableDuration defaultConnectTimeout, HumanReadableDuration defaultReadTimeout, HumanReadableDuration defaultWriteTimeout, HumanReadableDuration defaultBackoffSlotSize, Boolean defaultEnableGcmCipherSuites, Boolean defaultEnableHttp2, Boolean defaultFallbackToCommonNameVerification) {
        this.defaultApiToken = defaultApiToken;
        this.defaultSecurity = defaultSecurity;
        this.services = services;
        this.defaultProxyConfiguration = defaultProxyConfiguration;
        this.defaultConnectTimeout = defaultConnectTimeout;
        this.defaultReadTimeout = defaultReadTimeout;
        this.defaultWriteTimeout = defaultWriteTimeout;
        this.defaultBackoffSlotSize = defaultBackoffSlotSize;
        this.defaultEnableGcmCipherSuites = defaultEnableGcmCipherSuites;
        this.defaultEnableHttp2 = defaultEnableHttp2;
        this.defaultFallbackToCommonNameVerification = defaultFallbackToCommonNameVerification;
    }

    @Override
    @JsonProperty(value="apiToken")
    @JsonAlias(value={"api-token"})
    public Optional<BearerToken> defaultApiToken() {
        return Optional.ofNullable(this.defaultApiToken);
    }

    @Override
    @JsonProperty(value="security")
    public Optional<SslConfiguration> defaultSecurity() {
        return Optional.ofNullable(this.defaultSecurity);
    }

    @Override
    @JsonProperty(value="services")
    public Map<String, PartialServiceConfiguration> services() {
        return this.services;
    }

    @Override
    @JsonProperty(value="proxyConfiguration")
    @JsonAlias(value={"proxy-configuration"})
    public Optional<ProxyConfiguration> defaultProxyConfiguration() {
        return Optional.ofNullable(this.defaultProxyConfiguration);
    }

    @Override
    @JsonProperty(value="connectTimeout")
    @JsonAlias(value={"connect-timeout"})
    public Optional<HumanReadableDuration> defaultConnectTimeout() {
        return Optional.ofNullable(this.defaultConnectTimeout);
    }

    @Override
    @JsonProperty(value="readTimeout")
    @JsonAlias(value={"read-timeout"})
    public Optional<HumanReadableDuration> defaultReadTimeout() {
        return Optional.ofNullable(this.defaultReadTimeout);
    }

    @Override
    @JsonProperty(value="writeTimeout")
    @JsonAlias(value={"write-timeout"})
    public Optional<HumanReadableDuration> defaultWriteTimeout() {
        return Optional.ofNullable(this.defaultWriteTimeout);
    }

    @Override
    @JsonProperty(value="backoffSlotSize")
    @JsonAlias(value={"backoff-slot-size"})
    public Optional<HumanReadableDuration> defaultBackoffSlotSize() {
        return Optional.ofNullable(this.defaultBackoffSlotSize);
    }

    @Override
    @JsonProperty(value="enableGcmCipherSuites")
    @JsonAlias(value={"enable-gcm-cipher-suites"})
    public Optional<Boolean> defaultEnableGcmCipherSuites() {
        return Optional.ofNullable(this.defaultEnableGcmCipherSuites);
    }

    @Override
    @JsonProperty(value="enableHttp2")
    @JsonAlias(value={"enable-http2"})
    public Optional<Boolean> defaultEnableHttp2() {
        return Optional.ofNullable(this.defaultEnableHttp2);
    }

    @Override
    @JsonProperty(value="fallbackToCommonNameVerification")
    @JsonAlias(value={"fallback-to-common-name-verification"})
    @Deprecated
    public Optional<Boolean> defaultFallbackToCommonNameVerification() {
        return Optional.ofNullable(this.defaultFallbackToCommonNameVerification);
    }

    public final ImmutableServicesConfigBlock withDefaultApiToken(BearerToken value) {
        BearerToken newValue = Objects.requireNonNull(value, "defaultApiToken");
        if (this.defaultApiToken == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(newValue, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultApiToken(Optional<? extends BearerToken> optional) {
        BearerToken value = optional.orElse(null);
        if (this.defaultApiToken == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(value, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultSecurity(SslConfiguration value) {
        SslConfiguration newValue = Objects.requireNonNull(value, "defaultSecurity");
        if (this.defaultSecurity == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, newValue, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultSecurity(Optional<? extends SslConfiguration> optional) {
        SslConfiguration value = optional.orElse(null);
        if (this.defaultSecurity == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, value, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withServices(Map<String, ? extends PartialServiceConfiguration> entries) {
        if (this.services == entries) {
            return this;
        }
        Map<String, PartialServiceConfiguration> newValue = ImmutableServicesConfigBlock.createUnmodifiableMap(true, false, entries);
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, newValue, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultProxyConfiguration(ProxyConfiguration value) {
        ProxyConfiguration newValue = Objects.requireNonNull(value, "defaultProxyConfiguration");
        if (this.defaultProxyConfiguration == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, newValue, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultProxyConfiguration(Optional<? extends ProxyConfiguration> optional) {
        ProxyConfiguration value = optional.orElse(null);
        if (this.defaultProxyConfiguration == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, value, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultConnectTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "defaultConnectTimeout");
        if (this.defaultConnectTimeout == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, newValue, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultConnectTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.defaultConnectTimeout == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, value, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultReadTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "defaultReadTimeout");
        if (this.defaultReadTimeout == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, newValue, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultReadTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.defaultReadTimeout == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, value, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultWriteTimeout(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "defaultWriteTimeout");
        if (this.defaultWriteTimeout == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, newValue, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultWriteTimeout(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.defaultWriteTimeout == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, value, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultBackoffSlotSize(HumanReadableDuration value) {
        HumanReadableDuration newValue = Objects.requireNonNull(value, "defaultBackoffSlotSize");
        if (this.defaultBackoffSlotSize == newValue) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, newValue, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultBackoffSlotSize(Optional<? extends HumanReadableDuration> optional) {
        HumanReadableDuration value = optional.orElse(null);
        if (this.defaultBackoffSlotSize == value) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, value, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultEnableGcmCipherSuites(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defaultEnableGcmCipherSuites, newValue)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, newValue, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultEnableGcmCipherSuites(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defaultEnableGcmCipherSuites, value)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, value, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultEnableHttp2(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defaultEnableHttp2, newValue)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, newValue, this.defaultFallbackToCommonNameVerification));
    }

    public final ImmutableServicesConfigBlock withDefaultEnableHttp2(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defaultEnableHttp2, value)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, value, this.defaultFallbackToCommonNameVerification));
    }

    @Deprecated
    public final ImmutableServicesConfigBlock withDefaultFallbackToCommonNameVerification(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.defaultFallbackToCommonNameVerification, newValue)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, newValue));
    }

    @Deprecated
    public final ImmutableServicesConfigBlock withDefaultFallbackToCommonNameVerification(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.defaultFallbackToCommonNameVerification, value)) {
            return this;
        }
        return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, this.services, this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServicesConfigBlock && this.equalsByValue((ImmutableServicesConfigBlock)another);
    }

    private boolean equalsByValue(ImmutableServicesConfigBlock another) {
        return Objects.equals(this.defaultApiToken, another.defaultApiToken) && Objects.equals(this.defaultSecurity, another.defaultSecurity) && this.services.equals(another.services) && Objects.equals(this.defaultProxyConfiguration, another.defaultProxyConfiguration) && Objects.equals(this.defaultConnectTimeout, another.defaultConnectTimeout) && Objects.equals(this.defaultReadTimeout, another.defaultReadTimeout) && Objects.equals(this.defaultWriteTimeout, another.defaultWriteTimeout) && Objects.equals(this.defaultBackoffSlotSize, another.defaultBackoffSlotSize) && Objects.equals(this.defaultEnableGcmCipherSuites, another.defaultEnableGcmCipherSuites) && Objects.equals(this.defaultEnableHttp2, another.defaultEnableHttp2) && Objects.equals(this.defaultFallbackToCommonNameVerification, another.defaultFallbackToCommonNameVerification);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultApiToken);
        h += (h << 5) + Objects.hashCode(this.defaultSecurity);
        h += (h << 5) + this.services.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultProxyConfiguration);
        h += (h << 5) + Objects.hashCode(this.defaultConnectTimeout);
        h += (h << 5) + Objects.hashCode(this.defaultReadTimeout);
        h += (h << 5) + Objects.hashCode(this.defaultWriteTimeout);
        h += (h << 5) + Objects.hashCode(this.defaultBackoffSlotSize);
        h += (h << 5) + Objects.hashCode(this.defaultEnableGcmCipherSuites);
        h += (h << 5) + Objects.hashCode(this.defaultEnableHttp2);
        h += (h << 5) + Objects.hashCode(this.defaultFallbackToCommonNameVerification);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ServicesConfigBlock{");
        if (this.defaultSecurity != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("defaultSecurity=").append(this.defaultSecurity);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("services=").append(this.services);
        if (this.defaultProxyConfiguration != null) {
            builder.append(", ");
            builder.append("defaultProxyConfiguration=").append(this.defaultProxyConfiguration);
        }
        if (this.defaultConnectTimeout != null) {
            builder.append(", ");
            builder.append("defaultConnectTimeout=").append(this.defaultConnectTimeout);
        }
        if (this.defaultReadTimeout != null) {
            builder.append(", ");
            builder.append("defaultReadTimeout=").append(this.defaultReadTimeout);
        }
        if (this.defaultWriteTimeout != null) {
            builder.append(", ");
            builder.append("defaultWriteTimeout=").append(this.defaultWriteTimeout);
        }
        if (this.defaultBackoffSlotSize != null) {
            builder.append(", ");
            builder.append("defaultBackoffSlotSize=").append(this.defaultBackoffSlotSize);
        }
        if (this.defaultEnableGcmCipherSuites != null) {
            builder.append(", ");
            builder.append("defaultEnableGcmCipherSuites=").append(this.defaultEnableGcmCipherSuites);
        }
        if (this.defaultEnableHttp2 != null) {
            builder.append(", ");
            builder.append("defaultEnableHttp2=").append(this.defaultEnableHttp2);
        }
        if (this.defaultFallbackToCommonNameVerification != null) {
            builder.append(", ");
            builder.append("defaultFallbackToCommonNameVerification=").append(this.defaultFallbackToCommonNameVerification);
        }
        return builder.append("}").toString();
    }

    public static ServicesConfigBlock of() {
        return INSTANCE;
    }

    private static ImmutableServicesConfigBlock validate(ImmutableServicesConfigBlock instance) {
        return INSTANCE != null && INSTANCE.equalsByValue(instance) ? INSTANCE : instance;
    }

    public static ServicesConfigBlock copyOf(ServicesConfigBlock instance) {
        if (instance instanceof ImmutableServicesConfigBlock) {
            return (ImmutableServicesConfigBlock)instance;
        }
        return new ServicesConfigBlock.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ServicesConfigBlock", generator="Immutables")
    public static class Builder {
        private BearerToken defaultApiToken;
        private SslConfiguration defaultSecurity;
        private Map<String, PartialServiceConfiguration> services = new LinkedHashMap<String, PartialServiceConfiguration>();
        private ProxyConfiguration defaultProxyConfiguration;
        private HumanReadableDuration defaultConnectTimeout;
        private HumanReadableDuration defaultReadTimeout;
        private HumanReadableDuration defaultWriteTimeout;
        private HumanReadableDuration defaultBackoffSlotSize;
        private Boolean defaultEnableGcmCipherSuites;
        private Boolean defaultEnableHttp2;
        private Boolean defaultFallbackToCommonNameVerification;

        public Builder() {
            if (!(this instanceof ServicesConfigBlock.Builder)) {
                throw new UnsupportedOperationException("Use: new ServicesConfigBlock.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder from(ServicesConfigBlock instance) {
            Optional<Boolean> defaultFallbackToCommonNameVerificationOptional;
            Optional<Boolean> defaultEnableHttp2Optional;
            Optional<Boolean> defaultEnableGcmCipherSuitesOptional;
            Optional<HumanReadableDuration> defaultBackoffSlotSizeOptional;
            Optional<HumanReadableDuration> defaultWriteTimeoutOptional;
            Optional<HumanReadableDuration> defaultReadTimeoutOptional;
            Optional<HumanReadableDuration> defaultConnectTimeoutOptional;
            Optional<SslConfiguration> defaultSecurityOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<BearerToken> defaultApiTokenOptional = instance.defaultApiToken();
            if (defaultApiTokenOptional.isPresent()) {
                this.defaultApiToken(defaultApiTokenOptional);
            }
            if ((defaultSecurityOptional = instance.defaultSecurity()).isPresent()) {
                this.defaultSecurity(defaultSecurityOptional);
            }
            this.putAllServices(instance.services());
            Optional<ProxyConfiguration> defaultProxyConfigurationOptional = instance.defaultProxyConfiguration();
            if (defaultProxyConfigurationOptional.isPresent()) {
                this.defaultProxyConfiguration(defaultProxyConfigurationOptional);
            }
            if ((defaultConnectTimeoutOptional = instance.defaultConnectTimeout()).isPresent()) {
                this.defaultConnectTimeout(defaultConnectTimeoutOptional);
            }
            if ((defaultReadTimeoutOptional = instance.defaultReadTimeout()).isPresent()) {
                this.defaultReadTimeout(defaultReadTimeoutOptional);
            }
            if ((defaultWriteTimeoutOptional = instance.defaultWriteTimeout()).isPresent()) {
                this.defaultWriteTimeout(defaultWriteTimeoutOptional);
            }
            if ((defaultBackoffSlotSizeOptional = instance.defaultBackoffSlotSize()).isPresent()) {
                this.defaultBackoffSlotSize(defaultBackoffSlotSizeOptional);
            }
            if ((defaultEnableGcmCipherSuitesOptional = instance.defaultEnableGcmCipherSuites()).isPresent()) {
                this.defaultEnableGcmCipherSuites(defaultEnableGcmCipherSuitesOptional);
            }
            if ((defaultEnableHttp2Optional = instance.defaultEnableHttp2()).isPresent()) {
                this.defaultEnableHttp2(defaultEnableHttp2Optional);
            }
            if ((defaultFallbackToCommonNameVerificationOptional = instance.defaultFallbackToCommonNameVerification()).isPresent()) {
                this.defaultFallbackToCommonNameVerification(defaultFallbackToCommonNameVerificationOptional);
            }
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultApiToken(BearerToken defaultApiToken) {
            this.defaultApiToken = Objects.requireNonNull(defaultApiToken, "defaultApiToken");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="apiToken")
        @JsonAlias(value={"api-token"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultApiToken(Optional<? extends BearerToken> defaultApiToken) {
            this.defaultApiToken = defaultApiToken.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultSecurity(SslConfiguration defaultSecurity) {
            this.defaultSecurity = Objects.requireNonNull(defaultSecurity, "defaultSecurity");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="security")
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultSecurity(Optional<? extends SslConfiguration> defaultSecurity) {
            this.defaultSecurity = defaultSecurity.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder putServices(String key, PartialServiceConfiguration value) {
            this.services.put(Objects.requireNonNull(key, "services key"), Objects.requireNonNull(value, value == null ? "services value for key: " + key : null));
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder putServices(Map.Entry<String, ? extends PartialServiceConfiguration> entry) {
            PartialServiceConfiguration v;
            String k = entry.getKey();
            this.services.put(Objects.requireNonNull(k, "services key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "services value for key: " + k : null));
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="services")
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder services(Map<String, ? extends PartialServiceConfiguration> entries) {
            this.services.clear();
            return this.putAllServices(entries);
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder putAllServices(Map<String, ? extends PartialServiceConfiguration> entries) {
            for (Map.Entry<String, ? extends PartialServiceConfiguration> e : entries.entrySet()) {
                PartialServiceConfiguration v;
                String k = e.getKey();
                this.services.put(Objects.requireNonNull(k, "services key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "services value for key: " + k : null));
            }
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultProxyConfiguration(ProxyConfiguration defaultProxyConfiguration) {
            this.defaultProxyConfiguration = Objects.requireNonNull(defaultProxyConfiguration, "defaultProxyConfiguration");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="proxyConfiguration")
        @JsonAlias(value={"proxy-configuration"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultProxyConfiguration(Optional<? extends ProxyConfiguration> defaultProxyConfiguration) {
            this.defaultProxyConfiguration = defaultProxyConfiguration.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultConnectTimeout(HumanReadableDuration defaultConnectTimeout) {
            this.defaultConnectTimeout = Objects.requireNonNull(defaultConnectTimeout, "defaultConnectTimeout");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="connectTimeout")
        @JsonAlias(value={"connect-timeout"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultConnectTimeout(Optional<? extends HumanReadableDuration> defaultConnectTimeout) {
            this.defaultConnectTimeout = defaultConnectTimeout.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultReadTimeout(HumanReadableDuration defaultReadTimeout) {
            this.defaultReadTimeout = Objects.requireNonNull(defaultReadTimeout, "defaultReadTimeout");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="readTimeout")
        @JsonAlias(value={"read-timeout"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultReadTimeout(Optional<? extends HumanReadableDuration> defaultReadTimeout) {
            this.defaultReadTimeout = defaultReadTimeout.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultWriteTimeout(HumanReadableDuration defaultWriteTimeout) {
            this.defaultWriteTimeout = Objects.requireNonNull(defaultWriteTimeout, "defaultWriteTimeout");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="writeTimeout")
        @JsonAlias(value={"write-timeout"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultWriteTimeout(Optional<? extends HumanReadableDuration> defaultWriteTimeout) {
            this.defaultWriteTimeout = defaultWriteTimeout.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultBackoffSlotSize(HumanReadableDuration defaultBackoffSlotSize) {
            this.defaultBackoffSlotSize = Objects.requireNonNull(defaultBackoffSlotSize, "defaultBackoffSlotSize");
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="backoffSlotSize")
        @JsonAlias(value={"backoff-slot-size"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultBackoffSlotSize(Optional<? extends HumanReadableDuration> defaultBackoffSlotSize) {
            this.defaultBackoffSlotSize = defaultBackoffSlotSize.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultEnableGcmCipherSuites(boolean defaultEnableGcmCipherSuites) {
            this.defaultEnableGcmCipherSuites = defaultEnableGcmCipherSuites;
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="enableGcmCipherSuites")
        @JsonAlias(value={"enable-gcm-cipher-suites"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultEnableGcmCipherSuites(Optional<Boolean> defaultEnableGcmCipherSuites) {
            this.defaultEnableGcmCipherSuites = defaultEnableGcmCipherSuites.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultEnableHttp2(boolean defaultEnableHttp2) {
            this.defaultEnableHttp2 = defaultEnableHttp2;
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="enableHttp2")
        @JsonAlias(value={"enable-http2"})
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultEnableHttp2(Optional<Boolean> defaultEnableHttp2) {
            this.defaultEnableHttp2 = defaultEnableHttp2.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultFallbackToCommonNameVerification(boolean defaultFallbackToCommonNameVerification) {
            this.defaultFallbackToCommonNameVerification = defaultFallbackToCommonNameVerification;
            return (ServicesConfigBlock.Builder)this;
        }

        @JsonProperty(value="fallbackToCommonNameVerification")
        @JsonAlias(value={"fallback-to-common-name-verification"})
        @Deprecated
        @CanIgnoreReturnValue
        public final ServicesConfigBlock.Builder defaultFallbackToCommonNameVerification(Optional<Boolean> defaultFallbackToCommonNameVerification) {
            this.defaultFallbackToCommonNameVerification = defaultFallbackToCommonNameVerification.orElse(null);
            return (ServicesConfigBlock.Builder)this;
        }

        public ServicesConfigBlock build() {
            return ImmutableServicesConfigBlock.validate(new ImmutableServicesConfigBlock(this.defaultApiToken, this.defaultSecurity, ImmutableServicesConfigBlock.createUnmodifiableMap(false, false, this.services), this.defaultProxyConfiguration, this.defaultConnectTimeout, this.defaultReadTimeout, this.defaultWriteTimeout, this.defaultBackoffSlotSize, this.defaultEnableGcmCipherSuites, this.defaultEnableHttp2, this.defaultFallbackToCommonNameVerification));
        }
    }
}

