/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.config.service.ProxyConfiguration;
import com.palantir.conjure.java.api.config.service.ServiceConfiguration;
import com.palantir.conjure.java.api.config.ssl.SslConfiguration;
import com.palantir.tokens.auth.BearerToken;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ServiceConfiguration", generator="Immutables")
final class ImmutableServiceConfiguration
implements ServiceConfiguration {
    private final BearerToken apiToken;
    private final SslConfiguration security;
    private final List<String> uris;
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final Integer maxNumRetries;
    private final Duration backoffSlotSize;
    private final Boolean enableGcmCipherSuites;
    private final Boolean enableHttp2;
    private final Boolean fallbackToCommonNameVerification;
    private final ProxyConfiguration proxy;

    private ImmutableServiceConfiguration(BearerToken apiToken, SslConfiguration security, List<String> uris, Duration connectTimeout, Duration readTimeout, Duration writeTimeout, Integer maxNumRetries, Duration backoffSlotSize, Boolean enableGcmCipherSuites, Boolean enableHttp2, Boolean fallbackToCommonNameVerification, ProxyConfiguration proxy) {
        this.apiToken = apiToken;
        this.security = security;
        this.uris = uris;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.maxNumRetries = maxNumRetries;
        this.backoffSlotSize = backoffSlotSize;
        this.enableGcmCipherSuites = enableGcmCipherSuites;
        this.enableHttp2 = enableHttp2;
        this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
        this.proxy = proxy;
    }

    @Override
    @JsonProperty(value="apiToken")
    public Optional<BearerToken> apiToken() {
        return Optional.ofNullable(this.apiToken);
    }

    @Override
    @JsonProperty(value="security", required=true)
    public SslConfiguration security() {
        return this.security;
    }

    @Override
    @JsonProperty(value="uris")
    public List<String> uris() {
        return this.uris;
    }

    @Override
    @JsonProperty(value="connectTimeout")
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    @JsonProperty(value="readTimeout")
    public Optional<Duration> readTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    @Override
    @JsonProperty(value="writeTimeout")
    public Optional<Duration> writeTimeout() {
        return Optional.ofNullable(this.writeTimeout);
    }

    @Override
    @JsonProperty(value="maxNumRetries")
    public Optional<Integer> maxNumRetries() {
        return Optional.ofNullable(this.maxNumRetries);
    }

    @Override
    @JsonProperty(value="backoffSlotSize")
    public Optional<Duration> backoffSlotSize() {
        return Optional.ofNullable(this.backoffSlotSize);
    }

    @Override
    @JsonProperty(value="enableGcmCipherSuites")
    public Optional<Boolean> enableGcmCipherSuites() {
        return Optional.ofNullable(this.enableGcmCipherSuites);
    }

    @Override
    @JsonProperty(value="enableHttp2")
    public Optional<Boolean> enableHttp2() {
        return Optional.ofNullable(this.enableHttp2);
    }

    @Override
    @JsonProperty(value="fallbackToCommonNameVerification")
    public Optional<Boolean> fallbackToCommonNameVerification() {
        return Optional.ofNullable(this.fallbackToCommonNameVerification);
    }

    @Override
    @JsonProperty(value="proxy")
    public Optional<ProxyConfiguration> proxy() {
        return Optional.ofNullable(this.proxy);
    }

    public final ImmutableServiceConfiguration withApiToken(BearerToken value) {
        BearerToken newValue = Objects.requireNonNull(value, "apiToken");
        if (this.apiToken == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(newValue, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withApiToken(Optional<? extends BearerToken> optional) {
        BearerToken value = optional.orElse(null);
        if (this.apiToken == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(value, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withSecurity(SslConfiguration value) {
        if (this.security == value) {
            return this;
        }
        SslConfiguration newValue = Objects.requireNonNull(value, "security");
        return new ImmutableServiceConfiguration(this.apiToken, newValue, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withUris(String ... elements) {
        List<String> newValue = ImmutableServiceConfiguration.createUnmodifiableList(false, ImmutableServiceConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableServiceConfiguration(this.apiToken, this.security, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withUris(Iterable<String> elements) {
        if (this.uris == elements) {
            return this;
        }
        List<String> newValue = ImmutableServiceConfiguration.createUnmodifiableList(false, ImmutableServiceConfiguration.createSafeList(elements, true, false));
        return new ImmutableServiceConfiguration(this.apiToken, this.security, newValue, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withConnectTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "connectTimeout");
        if (this.connectTimeout == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, newValue, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withConnectTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.connectTimeout == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, value, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withReadTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "readTimeout");
        if (this.readTimeout == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, newValue, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withReadTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.readTimeout == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, value, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withWriteTimeout(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "writeTimeout");
        if (this.writeTimeout == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, newValue, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withWriteTimeout(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.writeTimeout == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, value, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withMaxNumRetries(int value) {
        Integer newValue = value;
        if (Objects.equals(this.maxNumRetries, newValue)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, newValue, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withMaxNumRetries(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.maxNumRetries, value)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, value, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withBackoffSlotSize(Duration value) {
        Duration newValue = Objects.requireNonNull(value, "backoffSlotSize");
        if (this.backoffSlotSize == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, newValue, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withBackoffSlotSize(Optional<? extends Duration> optional) {
        Duration value = optional.orElse(null);
        if (this.backoffSlotSize == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, value, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withEnableGcmCipherSuites(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableGcmCipherSuites, newValue)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, newValue, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withEnableGcmCipherSuites(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableGcmCipherSuites, value)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, value, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withEnableHttp2(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.enableHttp2, newValue)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, newValue, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withEnableHttp2(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.enableHttp2, value)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, value, this.fallbackToCommonNameVerification, this.proxy);
    }

    public final ImmutableServiceConfiguration withFallbackToCommonNameVerification(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.fallbackToCommonNameVerification, newValue)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, newValue, this.proxy);
    }

    public final ImmutableServiceConfiguration withFallbackToCommonNameVerification(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.fallbackToCommonNameVerification, value)) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, value, this.proxy);
    }

    public final ImmutableServiceConfiguration withProxy(ProxyConfiguration value) {
        ProxyConfiguration newValue = Objects.requireNonNull(value, "proxy");
        if (this.proxy == newValue) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, newValue);
    }

    public final ImmutableServiceConfiguration withProxy(Optional<? extends ProxyConfiguration> optional) {
        ProxyConfiguration value = optional.orElse(null);
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableServiceConfiguration(this.apiToken, this.security, this.uris, this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceConfiguration && this.equalsByValue((ImmutableServiceConfiguration)another);
    }

    private boolean equalsByValue(ImmutableServiceConfiguration another) {
        return Objects.equals(this.apiToken, another.apiToken) && this.security.equals(another.security) && this.uris.equals(another.uris) && Objects.equals(this.connectTimeout, another.connectTimeout) && Objects.equals(this.readTimeout, another.readTimeout) && Objects.equals(this.writeTimeout, another.writeTimeout) && Objects.equals(this.maxNumRetries, another.maxNumRetries) && Objects.equals(this.backoffSlotSize, another.backoffSlotSize) && Objects.equals(this.enableGcmCipherSuites, another.enableGcmCipherSuites) && Objects.equals(this.enableHttp2, another.enableHttp2) && Objects.equals(this.fallbackToCommonNameVerification, another.fallbackToCommonNameVerification) && Objects.equals(this.proxy, another.proxy);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.apiToken);
        h += (h << 5) + this.security.hashCode();
        h += (h << 5) + this.uris.hashCode();
        h += (h << 5) + Objects.hashCode(this.connectTimeout);
        h += (h << 5) + Objects.hashCode(this.readTimeout);
        h += (h << 5) + Objects.hashCode(this.writeTimeout);
        h += (h << 5) + Objects.hashCode(this.maxNumRetries);
        h += (h << 5) + Objects.hashCode(this.backoffSlotSize);
        h += (h << 5) + Objects.hashCode(this.enableGcmCipherSuites);
        h += (h << 5) + Objects.hashCode(this.enableHttp2);
        h += (h << 5) + Objects.hashCode(this.fallbackToCommonNameVerification);
        h += (h << 5) + Objects.hashCode(this.proxy);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ServiceConfiguration{");
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("security=").append(this.security);
        builder.append(", ");
        builder.append("uris=").append(this.uris);
        if (this.connectTimeout != null) {
            builder.append(", ");
            builder.append("connectTimeout=").append(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            builder.append(", ");
            builder.append("readTimeout=").append(this.readTimeout);
        }
        if (this.writeTimeout != null) {
            builder.append(", ");
            builder.append("writeTimeout=").append(this.writeTimeout);
        }
        if (this.maxNumRetries != null) {
            builder.append(", ");
            builder.append("maxNumRetries=").append(this.maxNumRetries);
        }
        if (this.backoffSlotSize != null) {
            builder.append(", ");
            builder.append("backoffSlotSize=").append(this.backoffSlotSize);
        }
        if (this.enableGcmCipherSuites != null) {
            builder.append(", ");
            builder.append("enableGcmCipherSuites=").append(this.enableGcmCipherSuites);
        }
        if (this.enableHttp2 != null) {
            builder.append(", ");
            builder.append("enableHttp2=").append(this.enableHttp2);
        }
        if (this.fallbackToCommonNameVerification != null) {
            builder.append(", ");
            builder.append("fallbackToCommonNameVerification=").append(this.fallbackToCommonNameVerification);
        }
        if (this.proxy != null) {
            builder.append(", ");
            builder.append("proxy=").append(this.proxy);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceConfiguration fromJson(Json json) {
        ServiceConfiguration.Builder builder = new ServiceConfiguration.Builder();
        if (json._apiToken != null) {
            builder.apiToken(json._apiToken);
        }
        if (json._security != null) {
            builder.security(json._security);
        }
        if (json._uris != null) {
            builder.addAllUris(json._uris);
        }
        if (json._connectTimeout != null) {
            builder.connectTimeout(json._connectTimeout);
        }
        if (json._readTimeout != null) {
            builder.readTimeout(json._readTimeout);
        }
        if (json._writeTimeout != null) {
            builder.writeTimeout(json._writeTimeout);
        }
        if (json._maxNumRetries != null) {
            builder.maxNumRetries(json._maxNumRetries);
        }
        if (json._backoffSlotSize != null) {
            builder.backoffSlotSize(json._backoffSlotSize);
        }
        if (json._enableGcmCipherSuites != null) {
            builder.enableGcmCipherSuites(json._enableGcmCipherSuites);
        }
        if (json._enableHttp2 != null) {
            builder.enableHttp2(json._enableHttp2);
        }
        if (json._fallbackToCommonNameVerification != null) {
            builder.fallbackToCommonNameVerification(json._fallbackToCommonNameVerification);
        }
        if (json._proxy != null) {
            builder.proxy(json._proxy);
        }
        return (ImmutableServiceConfiguration)builder.build();
    }

    public static ServiceConfiguration copyOf(ServiceConfiguration instance) {
        if (instance instanceof ImmutableServiceConfiguration) {
            return (ImmutableServiceConfiguration)instance;
        }
        return new ServiceConfiguration.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ServiceConfiguration", generator="Immutables")
    static final class Json
    implements ServiceConfiguration {
        @JsonIgnore
        Optional<BearerToken> _apiToken = Optional.empty();
        @JsonIgnore
        SslConfiguration _security;
        @JsonIgnore
        List<String> _uris = Collections.emptyList();
        @JsonIgnore
        Optional<Duration> _connectTimeout = Optional.empty();
        @JsonIgnore
        Optional<Duration> _readTimeout = Optional.empty();
        @JsonIgnore
        Optional<Duration> _writeTimeout = Optional.empty();
        @JsonIgnore
        Optional<Integer> _maxNumRetries = Optional.empty();
        @JsonIgnore
        Optional<Duration> _backoffSlotSize = Optional.empty();
        @JsonIgnore
        Optional<Boolean> _enableGcmCipherSuites = Optional.empty();
        @JsonIgnore
        Optional<Boolean> _enableHttp2 = Optional.empty();
        @JsonIgnore
        Optional<Boolean> _fallbackToCommonNameVerification = Optional.empty();
        @JsonIgnore
        Optional<ProxyConfiguration> _proxy = Optional.empty();

        Json() {
        }

        @JsonProperty(value="apiToken")
        public void setApiToken(Optional<BearerToken> apiToken) {
            this._apiToken = apiToken;
        }

        @JsonProperty(value="security", required=true)
        public void setSecurity(SslConfiguration security) {
            this._security = security;
        }

        @JsonProperty(value="uris")
        public void setUris(List<String> uris) {
            this._uris = uris;
        }

        @JsonProperty(value="connectTimeout")
        public void setConnectTimeout(Optional<Duration> connectTimeout) {
            this._connectTimeout = connectTimeout;
        }

        @JsonProperty(value="readTimeout")
        public void setReadTimeout(Optional<Duration> readTimeout) {
            this._readTimeout = readTimeout;
        }

        @JsonProperty(value="writeTimeout")
        public void setWriteTimeout(Optional<Duration> writeTimeout) {
            this._writeTimeout = writeTimeout;
        }

        @JsonProperty(value="maxNumRetries")
        public void setMaxNumRetries(Optional<Integer> maxNumRetries) {
            this._maxNumRetries = maxNumRetries;
        }

        @JsonProperty(value="backoffSlotSize")
        public void setBackoffSlotSize(Optional<Duration> backoffSlotSize) {
            this._backoffSlotSize = backoffSlotSize;
        }

        @JsonProperty(value="enableGcmCipherSuites")
        public void setEnableGcmCipherSuites(Optional<Boolean> enableGcmCipherSuites) {
            this._enableGcmCipherSuites = enableGcmCipherSuites;
        }

        @JsonProperty(value="enableHttp2")
        public void setEnableHttp2(Optional<Boolean> enableHttp2) {
            this._enableHttp2 = enableHttp2;
        }

        @JsonProperty(value="fallbackToCommonNameVerification")
        public void setFallbackToCommonNameVerification(Optional<Boolean> fallbackToCommonNameVerification) {
            this._fallbackToCommonNameVerification = fallbackToCommonNameVerification;
        }

        @JsonProperty(value="proxy")
        public void setProxy(Optional<ProxyConfiguration> proxy) {
            this._proxy = proxy;
        }

        @Override
        public Optional<BearerToken> apiToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SslConfiguration security() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> uris() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Duration> connectTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Duration> readTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Duration> writeTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> maxNumRetries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Duration> backoffSlotSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> enableGcmCipherSuites() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> enableHttp2() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> fallbackToCommonNameVerification() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ProxyConfiguration> proxy() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ServiceConfiguration", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_SECURITY = 1L;
        private long initBits = 1L;
        private BearerToken apiToken;
        private SslConfiguration security;
        private List<String> uris = new ArrayList<String>();
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;
        private Integer maxNumRetries;
        private Duration backoffSlotSize;
        private Boolean enableGcmCipherSuites;
        private Boolean enableHttp2;
        private Boolean fallbackToCommonNameVerification;
        private ProxyConfiguration proxy;

        public Builder() {
            if (!(this instanceof ServiceConfiguration.Builder)) {
                throw new UnsupportedOperationException("Use: new ServiceConfiguration.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder from(ServiceConfiguration instance) {
            Optional<ProxyConfiguration> proxyOptional;
            Optional<Boolean> fallbackToCommonNameVerificationOptional;
            Optional<Boolean> enableHttp2Optional;
            Optional<Boolean> enableGcmCipherSuitesOptional;
            Optional<Duration> backoffSlotSizeOptional;
            Optional<Integer> maxNumRetriesOptional;
            Optional<Duration> writeTimeoutOptional;
            Optional<Duration> readTimeoutOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<BearerToken> apiTokenOptional = instance.apiToken();
            if (apiTokenOptional.isPresent()) {
                this.apiToken(apiTokenOptional);
            }
            this.security(instance.security());
            this.addAllUris(instance.uris());
            Optional<Duration> connectTimeoutOptional = instance.connectTimeout();
            if (connectTimeoutOptional.isPresent()) {
                this.connectTimeout(connectTimeoutOptional);
            }
            if ((readTimeoutOptional = instance.readTimeout()).isPresent()) {
                this.readTimeout(readTimeoutOptional);
            }
            if ((writeTimeoutOptional = instance.writeTimeout()).isPresent()) {
                this.writeTimeout(writeTimeoutOptional);
            }
            if ((maxNumRetriesOptional = instance.maxNumRetries()).isPresent()) {
                this.maxNumRetries(maxNumRetriesOptional);
            }
            if ((backoffSlotSizeOptional = instance.backoffSlotSize()).isPresent()) {
                this.backoffSlotSize(backoffSlotSizeOptional);
            }
            if ((enableGcmCipherSuitesOptional = instance.enableGcmCipherSuites()).isPresent()) {
                this.enableGcmCipherSuites(enableGcmCipherSuitesOptional);
            }
            if ((enableHttp2Optional = instance.enableHttp2()).isPresent()) {
                this.enableHttp2(enableHttp2Optional);
            }
            if ((fallbackToCommonNameVerificationOptional = instance.fallbackToCommonNameVerification()).isPresent()) {
                this.fallbackToCommonNameVerification(fallbackToCommonNameVerificationOptional);
            }
            if ((proxyOptional = instance.proxy()).isPresent()) {
                this.proxy(proxyOptional);
            }
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder apiToken(BearerToken apiToken) {
            this.apiToken = Objects.requireNonNull(apiToken, "apiToken");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="apiToken")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder apiToken(Optional<? extends BearerToken> apiToken) {
            this.apiToken = apiToken.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="security", required=true)
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder security(SslConfiguration security) {
            this.security = Objects.requireNonNull(security, "security");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder addUris(String element) {
            this.uris.add(Objects.requireNonNull(element, "uris element"));
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder addUris(String ... elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="uris")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder uris(Iterable<String> elements) {
            this.uris.clear();
            return this.addAllUris(elements);
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder addAllUris(Iterable<String> elements) {
            for (String element : elements) {
                this.uris.add(Objects.requireNonNull(element, "uris element"));
            }
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="connectTimeout")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder connectTimeout(Optional<? extends Duration> connectTimeout) {
            this.connectTimeout = connectTimeout.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder readTimeout(Duration readTimeout) {
            this.readTimeout = Objects.requireNonNull(readTimeout, "readTimeout");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="readTimeout")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder readTimeout(Optional<? extends Duration> readTimeout) {
            this.readTimeout = readTimeout.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = Objects.requireNonNull(writeTimeout, "writeTimeout");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="writeTimeout")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder writeTimeout(Optional<? extends Duration> writeTimeout) {
            this.writeTimeout = writeTimeout.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder maxNumRetries(int maxNumRetries) {
            this.maxNumRetries = maxNumRetries;
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="maxNumRetries")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder maxNumRetries(Optional<Integer> maxNumRetries) {
            this.maxNumRetries = maxNumRetries.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder backoffSlotSize(Duration backoffSlotSize) {
            this.backoffSlotSize = Objects.requireNonNull(backoffSlotSize, "backoffSlotSize");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="backoffSlotSize")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder backoffSlotSize(Optional<? extends Duration> backoffSlotSize) {
            this.backoffSlotSize = backoffSlotSize.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder enableGcmCipherSuites(boolean enableGcmCipherSuites) {
            this.enableGcmCipherSuites = enableGcmCipherSuites;
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="enableGcmCipherSuites")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder enableGcmCipherSuites(Optional<Boolean> enableGcmCipherSuites) {
            this.enableGcmCipherSuites = enableGcmCipherSuites.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder enableHttp2(boolean enableHttp2) {
            this.enableHttp2 = enableHttp2;
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="enableHttp2")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder enableHttp2(Optional<Boolean> enableHttp2) {
            this.enableHttp2 = enableHttp2.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder fallbackToCommonNameVerification(boolean fallbackToCommonNameVerification) {
            this.fallbackToCommonNameVerification = fallbackToCommonNameVerification;
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="fallbackToCommonNameVerification")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder fallbackToCommonNameVerification(Optional<Boolean> fallbackToCommonNameVerification) {
            this.fallbackToCommonNameVerification = fallbackToCommonNameVerification.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder proxy(ProxyConfiguration proxy) {
            this.proxy = Objects.requireNonNull(proxy, "proxy");
            return (ServiceConfiguration.Builder)this;
        }

        @JsonProperty(value="proxy")
        @CanIgnoreReturnValue
        public final ServiceConfiguration.Builder proxy(Optional<? extends ProxyConfiguration> proxy) {
            this.proxy = proxy.orElse(null);
            return (ServiceConfiguration.Builder)this;
        }

        public ServiceConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceConfiguration(this.apiToken, this.security, ImmutableServiceConfiguration.createUnmodifiableList(true, this.uris), this.connectTimeout, this.readTimeout, this.writeTimeout, this.maxNumRetries, this.backoffSlotSize, this.enableGcmCipherSuites, this.enableHttp2, this.fallbackToCommonNameVerification, this.proxy);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("security");
            }
            return "Cannot build ServiceConfiguration, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

