/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.config.service.UserAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="UserAgent.Agent", generator="Immutables")
final class ImmutableAgent
implements UserAgent.Agent {
    private final String name;
    private final String version;
    private final List<String> comments;

    private ImmutableAgent(String name, String version, List<String> comments) {
        this.name = name;
        this.version = version;
        this.comments = comments;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String version() {
        return this.version;
    }

    @Override
    public List<String> comments() {
        return this.comments;
    }

    public final ImmutableAgent withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableAgent.validate(new ImmutableAgent(newValue, this.version, this.comments));
    }

    public final ImmutableAgent withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (this.version.equals(newValue)) {
            return this;
        }
        return ImmutableAgent.validate(new ImmutableAgent(this.name, newValue, this.comments));
    }

    public final ImmutableAgent withComments(String ... elements) {
        List<String> newValue = ImmutableAgent.createUnmodifiableList(false, ImmutableAgent.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableAgent.validate(new ImmutableAgent(this.name, this.version, newValue));
    }

    public final ImmutableAgent withComments(Iterable<String> elements) {
        if (this.comments == elements) {
            return this;
        }
        List<String> newValue = ImmutableAgent.createUnmodifiableList(false, ImmutableAgent.createSafeList(elements, true, false));
        return ImmutableAgent.validate(new ImmutableAgent(this.name, this.version, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgent && this.equalsByValue((ImmutableAgent)another);
    }

    private boolean equalsByValue(ImmutableAgent another) {
        return this.name.equals(another.name) && this.version.equals(another.version) && this.comments.equals(another.comments);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.comments.hashCode();
        return h;
    }

    public String toString() {
        return "Agent{name=" + this.name + ", version=" + this.version + ", comments=" + String.valueOf(this.comments) + "}";
    }

    private static ImmutableAgent validate(ImmutableAgent instance) {
        instance.check();
        return instance;
    }

    public static UserAgent.Agent copyOf(UserAgent.Agent instance) {
        if (instance instanceof ImmutableAgent) {
            return (ImmutableAgent)instance;
        }
        return ImmutableAgent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UserAgent.Agent", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private long initBits = 3L;
        private String name;
        private String version;
        private List<String> comments = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(UserAgent.Agent instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.version(instance.version());
            this.addAllComments(instance.comments());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComments(String element) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addComments(String ... elements) {
            for (String element : elements) {
                this.comments.add(Objects.requireNonNull(element, "comments element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder comments(Iterable<String> elements) {
            this.comments.clear();
            return this.addAllComments(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllComments(Iterable<String> elements) {
            for (String element : elements) {
                this.comments.add(Objects.requireNonNull(element, "comments element"));
            }
            return this;
        }

        public UserAgent.Agent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAgent.validate(new ImmutableAgent(this.name, this.version, ImmutableAgent.createUnmodifiableList(true, this.comments)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build Agent, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

