/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.config.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HumanReadableDuration
implements Comparable<HumanReadableDuration>,
TemporalAmount {
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)\\s*(\\S+)");
    private static final Map<String, TimeUnit> SUFFIXES = HumanReadableDuration.createSuffixes();
    private final long count;
    private final TimeUnit unit;

    private static Map<String, TimeUnit> createSuffixes() {
        HashMap<String, TimeUnit> suffixes = new HashMap<String, TimeUnit>();
        suffixes.put("ns", TimeUnit.NANOSECONDS);
        suffixes.put("nanosecond", TimeUnit.NANOSECONDS);
        suffixes.put("nanoseconds", TimeUnit.NANOSECONDS);
        suffixes.put("us", TimeUnit.MICROSECONDS);
        suffixes.put("microsecond", TimeUnit.MICROSECONDS);
        suffixes.put("microseconds", TimeUnit.MICROSECONDS);
        suffixes.put("ms", TimeUnit.MILLISECONDS);
        suffixes.put("millisecond", TimeUnit.MILLISECONDS);
        suffixes.put("milliseconds", TimeUnit.MILLISECONDS);
        suffixes.put("s", TimeUnit.SECONDS);
        suffixes.put("second", TimeUnit.SECONDS);
        suffixes.put("seconds", TimeUnit.SECONDS);
        suffixes.put("m", TimeUnit.MINUTES);
        suffixes.put("minute", TimeUnit.MINUTES);
        suffixes.put("minutes", TimeUnit.MINUTES);
        suffixes.put("h", TimeUnit.HOURS);
        suffixes.put("hour", TimeUnit.HOURS);
        suffixes.put("hours", TimeUnit.HOURS);
        suffixes.put("d", TimeUnit.DAYS);
        suffixes.put("day", TimeUnit.DAYS);
        suffixes.put("days", TimeUnit.DAYS);
        return suffixes;
    }

    public static HumanReadableDuration nanoseconds(long count) {
        return new HumanReadableDuration(count, TimeUnit.NANOSECONDS);
    }

    public static HumanReadableDuration microseconds(long count) {
        return new HumanReadableDuration(count, TimeUnit.MICROSECONDS);
    }

    public static HumanReadableDuration milliseconds(long count) {
        return new HumanReadableDuration(count, TimeUnit.MILLISECONDS);
    }

    public static HumanReadableDuration seconds(long count) {
        return new HumanReadableDuration(count, TimeUnit.SECONDS);
    }

    public static HumanReadableDuration minutes(long count) {
        return new HumanReadableDuration(count, TimeUnit.MINUTES);
    }

    public static HumanReadableDuration hours(long count) {
        return new HumanReadableDuration(count, TimeUnit.HOURS);
    }

    public static HumanReadableDuration days(long count) {
        return new HumanReadableDuration(count, TimeUnit.DAYS);
    }

    @JsonCreator
    public static HumanReadableDuration valueOf(String duration) {
        Matcher matcher = DURATION_PATTERN.matcher(duration);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid duration", (Arg)SafeArg.of((String)"duration", (Object)duration));
        long count = Long.parseLong(matcher.group(1));
        TimeUnit unit = SUFFIXES.get(matcher.group(2));
        if (unit == null) {
            throw new SafeIllegalArgumentException("Invalid duration", new Arg[]{SafeArg.of((String)"duration", (Object)duration)});
        }
        return new HumanReadableDuration(count, unit);
    }

    private HumanReadableDuration(long count, TimeUnit unit) {
        this.count = count;
        this.unit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit), (String)"unit must not be null"));
    }

    public long getQuantity() {
        return this.count;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long toNanoseconds() {
        return TimeUnit.NANOSECONDS.convert(this.count, this.unit);
    }

    public long toMicroseconds() {
        return TimeUnit.MICROSECONDS.convert(this.count, this.unit);
    }

    public long toMilliseconds() {
        return TimeUnit.MILLISECONDS.convert(this.count, this.unit);
    }

    public long toSeconds() {
        return TimeUnit.SECONDS.convert(this.count, this.unit);
    }

    public long toMinutes() {
        return TimeUnit.MINUTES.convert(this.count, this.unit);
    }

    public long toHours() {
        return TimeUnit.HOURS.convert(this.count, this.unit);
    }

    public long toDays() {
        return TimeUnit.DAYS.convert(this.count, this.unit);
    }

    public Duration toJavaDuration() {
        return Duration.of(this.count, HumanReadableDuration.chronoUnit(this.unit));
    }

    private static ChronoUnit chronoUnit(TimeUnit unit) {
        return switch ((TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)unit), (String)"unit"))) {
            case TimeUnit.NANOSECONDS -> ChronoUnit.NANOS;
            case TimeUnit.MICROSECONDS -> ChronoUnit.MICROS;
            case TimeUnit.MILLISECONDS -> ChronoUnit.MILLIS;
            case TimeUnit.SECONDS -> ChronoUnit.SECONDS;
            case TimeUnit.MINUTES -> ChronoUnit.MINUTES;
            case TimeUnit.HOURS -> ChronoUnit.HOURS;
            case TimeUnit.DAYS -> ChronoUnit.DAYS;
            default -> throw new SafeIllegalArgumentException("Unknown TimeUnit constant", new Arg[]{SafeArg.of((String)"unit", (Object)((Object)unit))});
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HumanReadableDuration duration = (HumanReadableDuration)obj;
        return this.count == duration.count && this.unit == duration.unit;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + " " + units;
    }

    @Override
    public int compareTo(HumanReadableDuration other) {
        if (this.unit == other.unit) {
            return Long.compare(this.count, other.count);
        }
        return Long.compare(this.toNanoseconds(), other.toNanoseconds());
    }

    @Override
    public long get(TemporalUnit temporalUnit) {
        return this.toJavaDuration().get(temporalUnit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return this.toJavaDuration().getUnits();
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        return this.toJavaDuration().addTo(temporal);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        return this.toJavaDuration().subtractFrom(temporal);
    }
}

