/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.google.errorprone.annotations.CompileTimeConstant;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import org.intellij.lang.annotations.Pattern;

@Safe
public final class QosReason {
    @Safe
    private final String reason;
    private final Optional<RetryHint> retryHint;
    private final Optional<DueTo> dueTo;
    private static final String PATTERN_STRING = "^[a-z0-9\\-]{1,50}$";

    private QosReason(@Safe String reason, Optional<RetryHint> retryHint, Optional<DueTo> dueTo) {
        QosReason.checkReason(reason);
        this.reason = reason;
        this.retryHint = retryHint;
        this.dueTo = dueTo;
    }

    public static QosReason of(@Safe @CompileTimeConstant @Pattern(value="^[a-z0-9\\-]{1,50}$") String reason) {
        return new QosReason(reason, Optional.empty(), Optional.empty());
    }

    @Safe
    public String reason() {
        return this.reason;
    }

    public Optional<RetryHint> retryHint() {
        return this.retryHint;
    }

    public Optional<DueTo> dueTo() {
        return this.dueTo;
    }

    public String toString() {
        return this.reason;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof QosReason) {
            QosReason otherReason = (QosReason)other;
            return Objects.equals(this.reason, otherReason.reason) && Objects.equals(this.retryHint, otherReason.retryHint) && Objects.equals(this.dueTo, otherReason.dueTo);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.reason);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void checkReason(@Safe String reason) {
        if (reason == null || reason.isEmpty() || reason.length() > 50) {
            throw QosReason.invalidReason(reason);
        }
        for (int i = 0; i < reason.length(); ++i) {
            boolean validCharacter;
            char character = reason.charAt(i);
            boolean bl = validCharacter = character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '-';
            if (validCharacter) continue;
            throw QosReason.invalidReason(reason);
        }
    }

    @CheckReturnValue
    private static SafeIllegalArgumentException invalidReason(@Safe String reason) {
        return new SafeIllegalArgumentException("Reason must be at most 50 characters, and only contain lowercase letters, numbers, and hyphens (-).", new Arg[]{SafeArg.of((String)"reason", (Object)reason)});
    }

    public static final class Builder {
        @Nullable
        private String reason;
        @Nullable
        private RetryHint retryHint;
        @Nullable
        private DueTo dueTo;

        private Builder() {
        }

        public Builder from(QosReason other) {
            return this.reason(other.reason()).retryHint(other.retryHint()).dueTo(other.dueTo());
        }

        public Builder reason(@Safe @CompileTimeConstant @Pattern(value="^[a-z0-9\\-]{1,50}$") String value) {
            this.reason = (String)Preconditions.checkNotNull((Object)value, (String)"reason");
            return this;
        }

        public Builder retryHint(RetryHint value) {
            this.retryHint = (RetryHint)Preconditions.checkNotNull((Object)value, (String)"retryHint");
            return this;
        }

        public Builder retryHint(Optional<RetryHint> value) {
            this.retryHint = ((Optional)Preconditions.checkNotNull(value, (String)"retryHint")).orElse(null);
            return this;
        }

        public Builder dueTo(DueTo value) {
            this.dueTo = (DueTo)Preconditions.checkNotNull((Object)value, (String)"dueTo");
            return this;
        }

        public Builder dueTo(Optional<DueTo> value) {
            this.dueTo = ((Optional)Preconditions.checkNotNull(value, (String)"dueTo")).orElse(null);
            return this;
        }

        public QosReason build() {
            return new QosReason((String)Preconditions.checkNotNull((Object)this.reason, (String)"reason"), Optional.ofNullable(this.retryHint), Optional.ofNullable(this.dueTo));
        }
    }

    @Safe
    public static final class DueTo {
        private static final String CUSTOM_STRING = "custom";
        public static final DueTo CUSTOM = new DueTo("custom");
        @Safe
        private final String value;

        private DueTo(@Safe String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (String)"Value is required");
        }

        static DueTo valueOf(@Safe String value) {
            Preconditions.checkNotNull((Object)value, (String)"Value is required");
            if (CUSTOM_STRING.equalsIgnoreCase(value)) {
                return CUSTOM;
            }
            return new DueTo(value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DueTo dueTo = (DueTo)other;
            return this.value.equals(dueTo.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    @Safe
    public static final class RetryHint {
        private static final String DO_NOT_RETRY_STRING = "do-not-retry";
        public static final RetryHint DO_NOT_RETRY = new RetryHint("do-not-retry");
        @Safe
        private final String value;

        private RetryHint(@Safe String value) {
            this.value = (String)Preconditions.checkNotNull((Object)value, (String)"Value is required");
        }

        static RetryHint valueOf(@Safe String value) {
            Preconditions.checkNotNull((Object)value, (String)"Value is required");
            if (DO_NOT_RETRY_STRING.equalsIgnoreCase(value)) {
                return DO_NOT_RETRY;
            }
            return new RetryHint(value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RetryHint retryHint = (RetryHint)other;
            return this.value.equals(retryHint.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }
}

