/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ErrorType;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ErrorType", generator="Immutables")
@Immutable
final class ImmutableErrorType
extends ErrorType {
    private final ErrorType.Code code;
    private final String name;
    private final int httpErrorCode;

    private ImmutableErrorType(ErrorType.Code code, String name, int httpErrorCode) {
        this.code = Objects.requireNonNull(code, "code");
        this.name = Objects.requireNonNull(name, "name");
        this.httpErrorCode = httpErrorCode;
    }

    private ImmutableErrorType(ImmutableErrorType original, ErrorType.Code code, String name, int httpErrorCode) {
        this.code = code;
        this.name = name;
        this.httpErrorCode = httpErrorCode;
    }

    @Override
    public ErrorType.Code code() {
        return this.code;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int httpErrorCode() {
        return this.httpErrorCode;
    }

    public final ImmutableErrorType withCode(ErrorType.Code value) {
        ErrorType.Code newValue = Objects.requireNonNull(value, "code");
        if (this.code == newValue) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(this, newValue, this.name, this.httpErrorCode));
    }

    public final ImmutableErrorType withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(this, this.code, newValue, this.httpErrorCode));
    }

    public final ImmutableErrorType withHttpErrorCode(int value) {
        if (this.httpErrorCode == value) {
            return this;
        }
        return ImmutableErrorType.validate(new ImmutableErrorType(this, this.code, this.name, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorType && this.equalsByValue((ImmutableErrorType)another);
    }

    private boolean equalsByValue(ImmutableErrorType another) {
        return this.code.equals((Object)another.code) && this.name.equals(another.name) && this.httpErrorCode == another.httpErrorCode;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.httpErrorCode;
        return h;
    }

    public String toString() {
        return "ErrorType{code=" + String.valueOf((Object)this.code) + ", name=" + this.name + ", httpErrorCode=" + this.httpErrorCode + "}";
    }

    public static ErrorType of(ErrorType.Code code, String name, int httpErrorCode) {
        return ImmutableErrorType.validate(new ImmutableErrorType(code, name, httpErrorCode));
    }

    private static ImmutableErrorType validate(ImmutableErrorType instance) {
        instance.check();
        return instance;
    }

    public static ErrorType copyOf(ErrorType instance) {
        if (instance instanceof ImmutableErrorType) {
            return (ImmutableErrorType)instance;
        }
        return ImmutableErrorType.of(instance.code(), instance.name(), instance.httpErrorCode());
    }
}

