/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;

@Safe
public final class ConjureErrorParameterFormat {
    private static final String JSON = "JSON";
    public static final ConjureErrorParameterFormat JSON_FORMAT = new ConjureErrorParameterFormat("JSON");
    @Safe
    private final String value;

    private ConjureErrorParameterFormat(@Safe String value) {
        this.value = (String)Preconditions.checkNotNull((Object)value, (String)"Value is required");
    }

    static ConjureErrorParameterFormat valueOf(@Safe String value) {
        Preconditions.checkNotNull((Object)value, (String)"Value is required");
        if (JSON.equalsIgnoreCase(value)) {
            return JSON_FORMAT;
        }
        return new ConjureErrorParameterFormat(value);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ConjureErrorParameterFormat format = (ConjureErrorParameterFormat)other;
        return this.value.equals(format.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }
}

