/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.CheckedServiceException;
import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.RemoteException;
import com.palantir.conjure.java.api.errors.ServiceException;
import com.palantir.logsafe.Arg;
import com.palantir.tritium.ids.UniqueIds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

final class ServiceExceptionUtils {
    private ServiceExceptionUtils() {
    }

    static <T> List<T> arrayToUnmodifiableList(T[] elements) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T item : elements) {
            if (item == null) continue;
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    static String renderUnsafeMessage(String exceptionName, ErrorType errorType, Arg<?> ... args) {
        String message = ServiceExceptionUtils.renderNoArgsMessage(exceptionName, errorType);
        if (args == null || args.length == 0) {
            return message;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(message).append(": {");
        boolean first = true;
        for (Arg<?> arg : args) {
            if (arg == null) continue;
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(arg.getName()).append("=").append(arg.getValue());
        }
        builder.append("}");
        return builder.toString();
    }

    static String renderNoArgsMessage(String exceptionName, ErrorType errorType) {
        return exceptionName + ": " + String.valueOf((Object)errorType.code()) + " (" + errorType.name() + ")";
    }

    static String generateErrorInstanceId(@Nullable Throwable cause) {
        return ServiceExceptionUtils.generateErrorInstanceId(cause, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static String generateErrorInstanceId(@Nullable Throwable cause, Set<Throwable> dejaVu) {
        if (cause == null || !dejaVu.add(cause)) {
            return UniqueIds.pseudoRandomUuidV4().toString();
        }
        if (cause instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)cause;
            return serviceException.getErrorInstanceId();
        }
        if (cause instanceof CheckedServiceException) {
            CheckedServiceException checkedServiceException = (CheckedServiceException)cause;
            return checkedServiceException.getErrorInstanceId();
        }
        if (cause instanceof RemoteException) {
            RemoteException remoteException = (RemoteException)cause;
            return remoteException.getError().errorInstanceId();
        }
        return ServiceExceptionUtils.generateErrorInstanceId(cause.getCause(), dejaVu);
    }
}

