/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.ServiceExceptionUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import java.util.List;
import javax.annotation.Nullable;

public final class ServiceException
extends RuntimeException
implements SafeLoggable {
    private static final String EXCEPTION_NAME = "ServiceException";
    private final ErrorType errorType;
    private final List<Arg<?>> args;
    private final String errorInstanceId;
    private final String unsafeMessage;
    private final String noArgsMessage;

    public ServiceException(ErrorType errorType, Arg<?> ... parameters) {
        this(errorType, (Throwable)null, parameters);
    }

    public ServiceException(ErrorType errorType, @Nullable Throwable cause, Arg<?> ... args) {
        super(cause);
        this.errorInstanceId = ServiceExceptionUtils.generateErrorInstanceId(cause);
        this.errorType = errorType;
        this.args = ServiceExceptionUtils.arrayToUnmodifiableList(args);
        this.unsafeMessage = ServiceExceptionUtils.renderUnsafeMessage(EXCEPTION_NAME, errorType, args);
        this.noArgsMessage = ServiceExceptionUtils.renderNoArgsMessage(EXCEPTION_NAME, errorType);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getErrorInstanceId() {
        return this.errorInstanceId;
    }

    @Override
    public String getMessage() {
        return this.unsafeMessage;
    }

    public String getLogMessage() {
        return this.noArgsMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.args;
    }

    @Deprecated
    public List<Arg<?>> getParameters() {
        return this.getArgs();
    }
}

