/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.QosReason;
import java.util.Optional;

public final class QosReasons {
    private static final String CLIENT_REASON = "client-qos-response";
    private static final QosReason DEFAULT_CLIENT_REASON = QosReason.of("client-qos-response");
    private static final String DUE_TO_HEADER = "Qos-Due-To";
    private static final String RETRY_HINT_HEADER = "Qos-Retry-Hint";

    public static <T> void encodeToResponse(QosReason reason, T response, QosResponseEncodingAdapter<? super T> adapter) {
        if (reason.dueTo().isPresent()) {
            adapter.setHeader(response, DUE_TO_HEADER, QosReasons.toHeaderValue(reason.dueTo().get()));
        }
        if (reason.retryHint().isPresent()) {
            adapter.setHeader(response, RETRY_HINT_HEADER, QosReasons.toHeaderValue(reason.retryHint().get()));
        }
    }

    public static <T> QosReason parseFromResponse(T response, QosResponseDecodingAdapter<? super T> adapter) {
        Optional<String> maybeDueTo = adapter.getFirstHeader(response, DUE_TO_HEADER);
        Optional<String> maybeRetryHint = adapter.getFirstHeader(response, RETRY_HINT_HEADER);
        if (maybeDueTo.isEmpty() && maybeRetryHint.isEmpty()) {
            return DEFAULT_CLIENT_REASON;
        }
        return QosReason.builder().reason(CLIENT_REASON).dueTo(maybeDueTo.map(QosReasons::parseDueTo)).retryHint(maybeRetryHint.map(QosReasons::parseRetryHint)).build();
    }

    static QosReason.DueTo parseDueTo(String dueTo) {
        return QosReason.DueTo.valueOf(dueTo);
    }

    static QosReason.RetryHint parseRetryHint(String retryHint) {
        return QosReason.RetryHint.valueOf(retryHint);
    }

    static String toHeaderValue(QosReason.DueTo dueTo) {
        return dueTo.toString();
    }

    static String toHeaderValue(QosReason.RetryHint retryHint) {
        return retryHint.toString();
    }

    private QosReasons() {
    }

    public static interface QosResponseEncodingAdapter<RESPONSE> {
        public void setHeader(RESPONSE var1, String var2, String var3);
    }

    public static interface QosResponseDecodingAdapter<RESPONSE> {
        public Optional<String> getFirstHeader(RESPONSE var1, String var2);
    }
}

