/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ImmutableErrorType;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable(builder=false)
public abstract class ErrorType {
    private static final String UPPER_CAMEL_CASE = "(([A-Z][a-z0-9]+)+)";
    private static final Pattern ERROR_NAME_PATTERN = Pattern.compile(String.format("%s:%s", "(([A-Z][a-z0-9]+)+)", "(([A-Z][a-z0-9]+)+)"));
    public static final ErrorType UNAUTHORIZED = ErrorType.create(Code.UNAUTHORIZED, "Default:Unauthorized");
    public static final ErrorType PERMISSION_DENIED = ErrorType.create(Code.PERMISSION_DENIED, "Default:PermissionDenied");
    public static final ErrorType INVALID_ARGUMENT = ErrorType.create(Code.INVALID_ARGUMENT, "Default:InvalidArgument");
    public static final ErrorType REQUEST_ENTITY_TOO_LARGE = ErrorType.create(Code.REQUEST_ENTITY_TOO_LARGE, "Default:RequestEntityTooLarge");
    public static final ErrorType NOT_FOUND = ErrorType.create(Code.NOT_FOUND, "Default:NotFound");
    public static final ErrorType CONFLICT = ErrorType.create(Code.CONFLICT, "Default:Conflict");
    public static final ErrorType FAILED_PRECONDITION = ErrorType.create(Code.FAILED_PRECONDITION, "Default:FailedPrecondition");
    public static final ErrorType INTERNAL = ErrorType.create(Code.INTERNAL, "Default:Internal");
    public static final ErrorType TIMEOUT = ErrorType.create(Code.TIMEOUT, "Default:Timeout");

    @Value.Parameter
    public abstract Code code();

    @Value.Parameter
    public abstract String name();

    @Value.Parameter
    public abstract int httpErrorCode();

    @Value.Check
    final void check() {
        if (!ERROR_NAME_PATTERN.matcher(this.name()).matches()) {
            throw new SafeIllegalArgumentException("ErrorType names must be of the form 'UpperCamelNamespace:UpperCamelName'", new Arg[]{SafeArg.of((String)"name", (Object)this.name())});
        }
    }

    public static ErrorType create(Code code, String name) {
        return ImmutableErrorType.of(code, name, code.httpErrorCode);
    }

    public static enum Code {
        UNAUTHORIZED(401),
        PERMISSION_DENIED(403),
        INVALID_ARGUMENT(400),
        NOT_FOUND(404),
        CONFLICT(409),
        REQUEST_ENTITY_TOO_LARGE(413),
        FAILED_PRECONDITION(500),
        INTERNAL(500),
        TIMEOUT(500),
        CUSTOM_CLIENT(400),
        CUSTOM_SERVER(500);

        private final Integer httpErrorCode;

        private Code(Integer httpErrorCode) {
            this.httpErrorCode = httpErrorCode;
        }
    }
}

