/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ConjureErrorParameterFormat;
import com.palantir.logsafe.Preconditions;
import java.util.Optional;

public final class ConjureErrorParameterFormats {
    static final String ACCEPT_CONJURE_ERROR_PARAMETER_FORMAT_HEADER = "Accept-Conjure-Error-Parameter-Format";

    public static <T> void encodeToRequest(ConjureErrorParameterFormat format, T request, ConjureErrorParameterFormatRequestEncodingAdapter<? super T> adapter) {
        Preconditions.checkNotNull((Object)format, (String)"Conjure error parameter format is required");
        Preconditions.checkNotNull(request, (String)"Request is required");
        Preconditions.checkNotNull(adapter, (String)"Adapter is required");
        adapter.setHeader(request, ACCEPT_CONJURE_ERROR_PARAMETER_FORMAT_HEADER, format.toString());
    }

    public static <T> Optional<ConjureErrorParameterFormat> parseFromRequest(T request, ConjureErrorParameterFormatRequestDecodingAdapter<? super T> adapter) {
        Preconditions.checkNotNull(request, (String)"Request is required");
        Preconditions.checkNotNull(adapter, (String)"Adapter is required");
        String headerValue = adapter.getFirstHeader(request, ACCEPT_CONJURE_ERROR_PARAMETER_FORMAT_HEADER);
        if (headerValue == null || headerValue.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ConjureErrorParameterFormat.valueOf(headerValue));
    }

    private ConjureErrorParameterFormats() {
    }

    public static interface ConjureErrorParameterFormatRequestEncodingAdapter<REQUEST> {
        public void setHeader(REQUEST var1, String var2, String var3);
    }

    public static interface ConjureErrorParameterFormatRequestDecodingAdapter<REQUEST> {
        public String getFirstHeader(REQUEST var1, String var2);
    }
}

