/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.ErrorType;
import com.palantir.conjure.java.api.errors.ServiceExceptionUtils;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeLoggable;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CheckedServiceException
extends Exception
implements SafeLoggable {
    private static final String EXCEPTION_NAME = "CheckedServiceException";
    private final ErrorType errorType;
    private final List<Arg<?>> args;
    private final String errorInstanceId;
    private final String unsafeMessage;
    private final String noArgsMessage;

    @Deprecated(forRemoval=true)
    public CheckedServiceException(ErrorType errorType, Arg<?> ... parameters) {
        this(errorType, (Throwable)null, parameters);
    }

    @Deprecated(forRemoval=true)
    public CheckedServiceException(ErrorType errorType, @Nullable Throwable cause, Arg<?> ... args) {
        super(cause);
        this.errorInstanceId = ServiceExceptionUtils.generateErrorInstanceId(cause);
        this.errorType = errorType;
        this.args = ServiceExceptionUtils.arrayToUnmodifiableList(args);
        this.unsafeMessage = ServiceExceptionUtils.renderUnsafeMessage(EXCEPTION_NAME, errorType, args);
        this.noArgsMessage = ServiceExceptionUtils.renderNoArgsMessage(EXCEPTION_NAME, errorType);
    }

    public final ErrorType getErrorType() {
        return this.errorType;
    }

    public final String getErrorInstanceId() {
        return this.errorInstanceId;
    }

    @Override
    public final String getMessage() {
        return this.unsafeMessage;
    }

    public final String getLogMessage() {
        return this.noArgsMessage;
    }

    public final List<Arg<?>> getArgs() {
        return this.args;
    }
}

