/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.palantir.conjure.java.api.errors.SerializableError;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.SafeLoggable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RemoteException
extends RuntimeException
implements SafeLoggable {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_INSTANCE_ID = "errorInstanceId";
    private static final String ERROR_CODE = "errorCode";
    private static final String ERROR_NAME = "errorName";
    private final String stableMessage;
    private final SerializableError error;
    private final int status;
    private final List<Arg<?>> args;
    private String unsafeMessage;

    public SerializableError getError() {
        return this.error;
    }

    public int getStatus() {
        return this.status;
    }

    public RemoteException(SerializableError error, int status) {
        this.stableMessage = error.errorCode().equals(error.errorName()) ? "RemoteException: " + error.errorCode() : "RemoteException: " + error.errorCode() + " (" + error.errorName() + ")";
        this.error = error;
        this.status = status;
        this.args = Collections.unmodifiableList(Arrays.asList(SafeArg.of((String)ERROR_INSTANCE_ID, (Object)error.errorInstanceId()), SafeArg.of((String)ERROR_NAME, (Object)error.errorName()), SafeArg.of((String)ERROR_CODE, (Object)error.errorCode())));
    }

    @Override
    public String getMessage() {
        String messageValue = this.unsafeMessage;
        if (messageValue == null) {
            this.unsafeMessage = messageValue = this.renderUnsafeMessage();
        }
        return messageValue;
    }

    private String renderUnsafeMessage() {
        StringBuilder builder = new StringBuilder().append(this.stableMessage).append(" with instance ID ").append(this.error.errorInstanceId());
        if (!this.error.parameters().isEmpty()) {
            builder.append(": {");
            this.error.parameters().forEach((name, unsafeValue) -> builder.append((String)name).append('=').append((String)unsafeValue).append(", "));
            builder.setLength(builder.length() - 1);
            builder.setCharAt(builder.length() - 1, '}');
        }
        return builder.toString();
    }

    public String getLogMessage() {
        return this.stableMessage;
    }

    public List<Arg<?>> getArgs() {
        return this.args;
    }
}

