/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.api.errors;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.palantir.conjure.java.api.errors.SerializableError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="SerializableError", generator="Immutables")
@Immutable
public final class ImmutableSerializableError
extends SerializableError {
    private final String errorCode;
    private final String errorName;
    private final String errorInstanceId;
    private final Map<String, String> parameters;
    @Nullable
    private final String exceptionClass;
    @Nullable
    private final String message;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSerializableError(Builder builder) {
        this.parameters = ImmutableSerializableError.createUnmodifiableMap(false, false, builder.parameters);
        this.exceptionClass = builder.exceptionClass;
        this.message = builder.message;
        if (builder.errorCode != null) {
            this.initShim.errorCode(builder.errorCode);
        }
        if (builder.errorName != null) {
            this.initShim.errorName(builder.errorName);
        }
        if (builder.errorInstanceId != null) {
            this.initShim.errorInstanceId(builder.errorInstanceId);
        }
        this.errorCode = this.initShim.errorCode();
        this.errorName = this.initShim.errorName();
        this.errorInstanceId = this.initShim.errorInstanceId();
        this.initShim = null;
    }

    private ImmutableSerializableError(String errorCode, String errorName, String errorInstanceId, Map<String, String> parameters, @Nullable String exceptionClass, @Nullable String message) {
        this.errorCode = errorCode;
        this.errorName = errorName;
        this.errorInstanceId = errorInstanceId;
        this.parameters = parameters;
        this.exceptionClass = exceptionClass;
        this.message = message;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="errorCode")
    public String errorCode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.errorCode() : this.errorCode;
    }

    @Override
    @JsonProperty(value="errorName")
    public String errorName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.errorName() : this.errorName;
    }

    @Override
    @JsonProperty(value="errorInstanceId")
    public String errorInstanceId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.errorInstanceId() : this.errorInstanceId;
    }

    @Override
    @JsonProperty(value="parameters", required=true)
    @JsonDeserialize(contentUsing=SerializableError.ParameterDeserializer.class)
    public Map<String, String> parameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="exceptionClass", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    Optional<String> getExceptionClass() {
        return Optional.ofNullable(this.exceptionClass);
    }

    @Override
    @JsonProperty(value="message", access=JsonProperty.Access.WRITE_ONLY)
    @Deprecated
    Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public final ImmutableSerializableError withErrorCode(String value) {
        String newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode.equals(newValue)) {
            return this;
        }
        return new ImmutableSerializableError(newValue, this.errorName, this.errorInstanceId, this.parameters, this.exceptionClass, this.message);
    }

    public final ImmutableSerializableError withErrorName(String value) {
        String newValue = Objects.requireNonNull(value, "errorName");
        if (this.errorName.equals(newValue)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, newValue, this.errorInstanceId, this.parameters, this.exceptionClass, this.message);
    }

    public final ImmutableSerializableError withErrorInstanceId(String value) {
        String newValue = Objects.requireNonNull(value, "errorInstanceId");
        if (this.errorInstanceId.equals(newValue)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, this.errorName, newValue, this.parameters, this.exceptionClass, this.message);
    }

    public final ImmutableSerializableError withParameters(Map<String, ? extends String> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableSerializableError.createUnmodifiableMap(true, false, entries);
        return new ImmutableSerializableError(this.errorCode, this.errorName, this.errorInstanceId, newValue, this.exceptionClass, this.message);
    }

    @Deprecated
    public final ImmutableSerializableError withExceptionClass(String value) {
        String newValue = Objects.requireNonNull(value, "exceptionClass");
        if (Objects.equals(this.exceptionClass, newValue)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, this.errorName, this.errorInstanceId, this.parameters, newValue, this.message);
    }

    @Deprecated
    public final ImmutableSerializableError withExceptionClass(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.exceptionClass, value)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, this.errorName, this.errorInstanceId, this.parameters, value, this.message);
    }

    @Deprecated
    public final ImmutableSerializableError withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (Objects.equals(this.message, newValue)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, this.errorName, this.errorInstanceId, this.parameters, this.exceptionClass, newValue);
    }

    @Deprecated
    public final ImmutableSerializableError withMessage(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.message, value)) {
            return this;
        }
        return new ImmutableSerializableError(this.errorCode, this.errorName, this.errorInstanceId, this.parameters, this.exceptionClass, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSerializableError && this.equalsByValue((ImmutableSerializableError)another);
    }

    private boolean equalsByValue(ImmutableSerializableError another) {
        return this.errorCode.equals(another.errorCode) && this.errorName.equals(another.errorName) && this.errorInstanceId.equals(another.errorInstanceId) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errorCode.hashCode();
        h += (h << 5) + this.errorName.hashCode();
        h += (h << 5) + this.errorInstanceId.hashCode();
        h += (h << 5) + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SerializableError{");
        builder.append("errorCode=").append(this.errorCode);
        builder.append(", ");
        builder.append("errorName=").append(this.errorName);
        builder.append(", ");
        builder.append("errorInstanceId=").append(this.errorInstanceId);
        builder.append(", ");
        builder.append("parameters=").append(this.parameters);
        return builder.append("}").toString();
    }

    public static ImmutableSerializableError copyOf(SerializableError instance) {
        if (instance instanceof ImmutableSerializableError) {
            return (ImmutableSerializableError)instance;
        }
        return new SerializableError.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="SerializableError", generator="Immutables")
    private final class InitShim {
        private byte errorCodeBuildStage = 0;
        private String errorCode;
        private byte errorNameBuildStage = 0;
        private String errorName;
        private byte errorInstanceIdBuildStage = 0;
        private String errorInstanceId;

        private InitShim() {
        }

        String errorCode() {
            if (this.errorCodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorCodeBuildStage == 0) {
                this.errorCodeBuildStage = (byte)-1;
                this.errorCode = Objects.requireNonNull(ImmutableSerializableError.super.errorCode(), "errorCode");
                this.errorCodeBuildStage = 1;
            }
            return this.errorCode;
        }

        void errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.errorCodeBuildStage = 1;
        }

        String errorName() {
            if (this.errorNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorNameBuildStage == 0) {
                this.errorNameBuildStage = (byte)-1;
                this.errorName = Objects.requireNonNull(ImmutableSerializableError.super.errorName(), "errorName");
                this.errorNameBuildStage = 1;
            }
            return this.errorName;
        }

        void errorName(String errorName) {
            this.errorName = errorName;
            this.errorNameBuildStage = 1;
        }

        String errorInstanceId() {
            if (this.errorInstanceIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.errorInstanceIdBuildStage == 0) {
                this.errorInstanceIdBuildStage = (byte)-1;
                this.errorInstanceId = Objects.requireNonNull(ImmutableSerializableError.super.errorInstanceId(), "errorInstanceId");
                this.errorInstanceIdBuildStage = 1;
            }
            return this.errorInstanceId;
        }

        void errorInstanceId(String errorInstanceId) {
            this.errorInstanceId = errorInstanceId;
            this.errorInstanceIdBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.errorCodeBuildStage == -1) {
                attributes.add("errorCode");
            }
            if (this.errorNameBuildStage == -1) {
                attributes.add("errorName");
            }
            if (this.errorInstanceIdBuildStage == -1) {
                attributes.add("errorInstanceId");
            }
            return "Cannot build SerializableError, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @Generated(from="SerializableError", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        @Nullable
        private String errorCode;
        @Nullable
        private String errorName;
        @Nullable
        private String errorInstanceId;
        private Map<String, String> parameters = new LinkedHashMap<String, String>();
        @Nullable
        private String exceptionClass;
        @Nullable
        private String message;

        public Builder() {
            if (!(this instanceof SerializableError.Builder)) {
                throw new UnsupportedOperationException("Use: new SerializableError.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final SerializableError.Builder from(SerializableError instance) {
            Optional<String> messageOptional;
            Objects.requireNonNull(instance, "instance");
            this.errorCode(instance.errorCode());
            this.errorName(instance.errorName());
            this.errorInstanceId(instance.errorInstanceId());
            this.putAllParameters(instance.parameters());
            Optional<String> exceptionClassOptional = instance.getExceptionClass();
            if (exceptionClassOptional.isPresent()) {
                this.exceptionClass(exceptionClassOptional);
            }
            if ((messageOptional = instance.getMessage()).isPresent()) {
                this.message(messageOptional);
            }
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="errorCode")
        @CanIgnoreReturnValue
        public final SerializableError.Builder errorCode(String errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="errorName")
        @CanIgnoreReturnValue
        public final SerializableError.Builder errorName(String errorName) {
            this.errorName = Objects.requireNonNull(errorName, "errorName");
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="errorInstanceId")
        @CanIgnoreReturnValue
        public final SerializableError.Builder errorInstanceId(String errorInstanceId) {
            this.errorInstanceId = Objects.requireNonNull(errorInstanceId, "errorInstanceId");
            return (SerializableError.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SerializableError.Builder putParameters(String key, String value) {
            this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, value == null ? "parameters value for key: " + key : null));
            return (SerializableError.Builder)this;
        }

        @CanIgnoreReturnValue
        public final SerializableError.Builder putParameters(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "parameters value for key: " + k : null));
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="parameters", required=true)
        @JsonDeserialize(contentUsing=SerializableError.ParameterDeserializer.class)
        @CanIgnoreReturnValue
        public final SerializableError.Builder parameters(Map<String, ? extends String> entries) {
            this.parameters.clear();
            return this.putAllParameters(entries);
        }

        @CanIgnoreReturnValue
        public final SerializableError.Builder putAllParameters(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "parameters value for key: " + k : null));
            }
            return (SerializableError.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final SerializableError.Builder exceptionClass(String exceptionClass) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass, "exceptionClass");
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="exceptionClass", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final SerializableError.Builder exceptionClass(Optional<String> exceptionClass) {
            this.exceptionClass = exceptionClass.orElse(null);
            return (SerializableError.Builder)this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final SerializableError.Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            return (SerializableError.Builder)this;
        }

        @JsonProperty(value="message", access=JsonProperty.Access.WRITE_ONLY)
        @Deprecated
        @CanIgnoreReturnValue
        public final SerializableError.Builder message(Optional<String> message) {
            this.message = message.orElse(null);
            return (SerializableError.Builder)this;
        }

        public ImmutableSerializableError build() {
            return new ImmutableSerializableError(this);
        }
    }
}

