/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.persister;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaData;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaDataSlot;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetadataField;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.FieldsManager;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.StreamingClass;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.FieldsContainer;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectsCache;
import com.ovea.jetty.session.serializer.jboss.serial.persister.ObjectInputStreamProxy;
import com.ovea.jetty.session.serializer.jboss.serial.persister.ObjectOutputStreamProxy;
import com.ovea.jetty.session.serializer.jboss.serial.persister.Persister;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;

public class RegularObjectPersister
implements Persister {
    byte id;

    @Override
    public byte getId() {
        return this.id;
    }

    @Override
    public void setId(byte id) {
        this.id = id;
    }

    @Override
    public void writeData(ClassMetaData metaData, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        RegularObjectPersister.defaultWrite(out, obj, metaData, substitution);
    }

    public static void defaultWrite(ObjectOutput output, Object obj, ClassMetaData metaClass, ObjectSubstitutionInterface substitution) throws IOException {
        ClassMetaDataSlot[] slots = metaClass.getSlots();
        for (int slotNr = 0; slotNr < slots.length; ++slotNr) {
            if (slots[slotNr].getPrivateMethodWrite() != null) {
                RegularObjectPersister.writeSlotWithMethod(slots[slotNr], output, obj, substitution);
                continue;
            }
            RegularObjectPersister.writeSlotWithFields(slots[slotNr], output, obj, substitution);
        }
    }

    private static void readSlotWithMethod(ClassMetaDataSlot slot, short[] fieldsKey, ObjectInput input, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            slot.getPrivateMethodRead().invoke(obj, new ObjectInputStreamProxy(input, fieldsKey, obj, slot, substitution));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IOException io = new IOException(e.getMessage());
            io.initCause(e);
            throw io;
        }
    }

    private static void writeSlotWithMethod(ClassMetaDataSlot slot, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            slot.getPrivateMethodWrite().invoke(obj, new ObjectOutputStreamProxy(out, obj, slot, substitution));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            IOException io = new IOException(e.getMessage());
            io.initCause(e);
            throw io;
        }
    }

    static void writeSlotWithFields(ClassMetaDataSlot slot, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        ClassMetadataField[] fields = slot.getFields();
        for (int fieldNR = 0; fieldNR < fields.length; ++fieldNR) {
            ClassMetadataField field = fields[fieldNR];
            if (field.getField().getType().isPrimitive() && !field.getField().getType().isArray()) {
                RegularObjectPersister.writeOnPrimitive(output, obj, field);
                continue;
            }
            Object value = null;
            value = FieldsManager.getFieldsManager().getObject(obj, field);
            output.writeObject(value);
        }
    }

    private static void writeOnPrimitive(ObjectOutput out, Object obj, ClassMetadataField metaField) throws IOException {
        block10: {
            try {
                Field field = metaField.getField();
                Class<?> clazz = field.getType();
                if (clazz == Integer.TYPE) {
                    out.writeInt(FieldsManager.getFieldsManager().getInt(obj, metaField));
                    break block10;
                }
                if (clazz == Byte.TYPE) {
                    out.writeByte(FieldsManager.getFieldsManager().getByte(obj, metaField));
                    break block10;
                }
                if (clazz == Long.TYPE) {
                    out.writeLong(FieldsManager.getFieldsManager().getLong(obj, metaField));
                    break block10;
                }
                if (clazz == Float.TYPE) {
                    out.writeFloat(FieldsManager.getFieldsManager().getFloat(obj, metaField));
                    break block10;
                }
                if (clazz == Double.TYPE) {
                    out.writeDouble(FieldsManager.getFieldsManager().getDouble(obj, metaField));
                    break block10;
                }
                if (clazz == Short.TYPE) {
                    out.writeShort(FieldsManager.getFieldsManager().getShort(obj, metaField));
                    break block10;
                }
                if (clazz == Character.TYPE) {
                    out.writeChar(field.getChar(obj));
                    break block10;
                }
                if (clazz == Boolean.TYPE) {
                    out.writeBoolean(field.getBoolean(obj));
                    break block10;
                }
                throw new RuntimeException("Unexpected datatype " + clazz.getName());
            }
            catch (IllegalAccessException access) {
                IOException io = new IOException(access.getMessage());
                io.initCause(access);
                throw io;
            }
        }
    }

    @Override
    public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        Object obj = metaData.newInstance();
        cache.putObjectInCacheRead(referenceId, obj);
        return RegularObjectPersister.defaultRead(input, obj, streaming, metaData, substitution);
    }

    public static Object defaultRead(ObjectInput input, Object obj, StreamingClass streaming, ClassMetaData metaData, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            ClassMetaDataSlot[] slots = metaData.getSlots();
            for (int slotNR = 0; slotNR < slots.length; ++slotNR) {
                ClassMetaDataSlot slot = metaData.getSlots()[slotNR];
                if (slot.getPrivateMethodRead() != null) {
                    RegularObjectPersister.readSlotWithMethod(slot, streaming.getKeyFields()[slotNR], input, obj, substitution);
                    continue;
                }
                RegularObjectPersister.readSlotWithFields(streaming.getKeyFields()[slotNR], slot, input, obj);
            }
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Error reading " + obj.getClass().getName(), e);
        }
    }

    static void readSlotWithFields(short[] fieldsKey, ClassMetaDataSlot slot, ObjectInput input, Object obj) throws IOException, ClassNotFoundException {
        short numberOfFields = (short)fieldsKey.length;
        for (short i = 0; i < numberOfFields; i = (short)(i + 1)) {
            ClassMetadataField field = slot.getFields()[fieldsKey[i]];
            if (field.getField().getType() == Integer.TYPE) {
                FieldsManager.getFieldsManager().setInt(obj, field, input.readInt());
                continue;
            }
            if (field.getField().getType() == Byte.TYPE) {
                FieldsManager.getFieldsManager().setByte(obj, field, input.readByte());
                continue;
            }
            if (field.getField().getType() == Long.TYPE) {
                FieldsManager.getFieldsManager().setLong(obj, field, input.readLong());
                continue;
            }
            if (field.getField().getType() == Float.TYPE) {
                FieldsManager.getFieldsManager().setFloat(obj, field, input.readFloat());
                continue;
            }
            if (field.getField().getType() == Double.TYPE) {
                FieldsManager.getFieldsManager().setDouble(obj, field, input.readDouble());
                continue;
            }
            if (field.getField().getType() == Short.TYPE) {
                FieldsManager.getFieldsManager().setShort(obj, field, input.readShort());
                continue;
            }
            if (field.getField().getType() == Character.TYPE) {
                FieldsManager.getFieldsManager().setCharacter(obj, field, input.readChar());
                continue;
            }
            if (field.getField().getType() == Boolean.TYPE) {
                FieldsManager.getFieldsManager().setBoolean(obj, field, input.readBoolean());
                continue;
            }
            Object objTmp = input.readObject();
            FieldsManager.getFieldsManager().setObject(obj, field, objTmp);
        }
    }

    static void writeSlotWithDefaultMethod(ClassMetaDataSlot slot, ObjectOutput out, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        ObjectOutputStreamProxy oos = new ObjectOutputStreamProxy(out, obj, slot, substitution);
        ObjectOutputStream.PutField putField = ((ObjectOutputStream)oos).putFields();
        ClassMetadataField[] fields = slot.getFields();
        FieldsManager fieldsManager = FieldsManager.getFieldsManager();
        for (int fieldNR = 0; fieldNR < fields.length; ++fieldNR) {
            ClassMetadataField classMetadataField = fields[fieldNR];
            Class<?> type = classMetadataField.getField().getType();
            String fieldName = classMetadataField.getFieldName();
            if (type == Boolean.TYPE) {
                putField.put(fieldName, fieldsManager.getBoolean(obj, classMetadataField));
                continue;
            }
            if (type == Byte.TYPE) {
                putField.put(fieldName, fieldsManager.getByte(obj, classMetadataField));
                continue;
            }
            if (type == Character.TYPE) {
                putField.put(fieldName, fieldsManager.getCharacter(obj, classMetadataField));
                continue;
            }
            if (type == Short.TYPE) {
                putField.put(fieldName, fieldsManager.getShort(obj, classMetadataField));
                continue;
            }
            if (type == Integer.TYPE) {
                putField.put(fieldName, fieldsManager.getInt(obj, classMetadataField));
                continue;
            }
            if (type == Long.TYPE) {
                putField.put(fieldName, fieldsManager.getLong(obj, classMetadataField));
                continue;
            }
            if (type == Float.TYPE) {
                putField.put(fieldName, fieldsManager.getFloat(obj, classMetadataField));
                continue;
            }
            if (type == Double.TYPE) {
                putField.put(fieldName, fieldsManager.getDouble(obj, classMetadataField));
                continue;
            }
            Object value = fieldsManager.getObject(obj, classMetadataField);
            putField.put(fieldName, value);
        }
        ((ObjectOutputStream)oos).writeFields();
    }

    static void readSlotWithDefaultMethod(ClassMetaDataSlot slot, short[] fieldsKey, ObjectInput input, Object obj) throws IOException, ClassNotFoundException {
        FieldsContainer container = new FieldsContainer(slot);
        container.readMyself(input);
        ClassMetadataField[] fields = slot.getFields();
        ObjectInputStream.GetField getField = container.createGet();
        short numberOfFields = (short)fieldsKey.length;
        for (short i = 0; i < numberOfFields; i = (short)(i + 1)) {
            ClassMetadataField classMetadata = slot.getFields()[fieldsKey[i]];
            Field field = classMetadata.getField();
            Class<?> type = field.getType();
            String name = classMetadata.getFieldName();
            FieldsManager fieldsManager = FieldsManager.getFieldsManager();
            if (type == Boolean.TYPE) {
                fieldsManager.setBoolean(obj, classMetadata, getField.get(name, false));
                continue;
            }
            if (type == Byte.TYPE) {
                fieldsManager.setByte(obj, classMetadata, getField.get(name, (byte)0));
                continue;
            }
            if (type == Character.TYPE) {
                fieldsManager.setCharacter(obj, classMetadata, getField.get(name, '\u0000'));
                continue;
            }
            if (type == Short.TYPE) {
                fieldsManager.setShort(obj, classMetadata, getField.get(name, (short)0));
                continue;
            }
            if (type == Integer.TYPE) {
                fieldsManager.setInt(obj, classMetadata, getField.get(name, 0));
                continue;
            }
            if (type == Long.TYPE) {
                fieldsManager.setLong(obj, classMetadata, getField.get(name, 0L));
                continue;
            }
            if (type == Float.TYPE) {
                fieldsManager.setFloat(obj, classMetadata, getField.get(name, 0.0f));
                continue;
            }
            if (type == Double.TYPE) {
                fieldsManager.setDouble(obj, classMetadata, getField.get(name, 0.0));
                continue;
            }
            fieldsManager.setObject(obj, classMetadata, getField.get(name, null));
        }
    }

    @Override
    public boolean canPersist(Object obj) {
        return false;
    }
}

