/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.persister;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaDataSlot;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.FieldsContainer;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import com.ovea.jetty.session.serializer.jboss.serial.persister.RegularObjectPersister;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class ObjectOutputStreamProxy
extends ObjectOutputStream {
    Object currentObj;
    ClassMetaDataSlot currentMetaClass;
    ObjectSubstitutionInterface currentSubstitution;
    FieldsContainer currentContainer = null;
    ObjectOutput bout;

    public ObjectOutputStreamProxy(ObjectOutput output, Object currentObj, ClassMetaDataSlot currentMetaClass, ObjectSubstitutionInterface currentSubstitution) throws IOException {
        this.bout = output;
        this.currentObj = currentObj;
        this.currentMetaClass = currentMetaClass;
        this.currentSubstitution = currentSubstitution;
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.bout.writeObject(obj);
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.writeObjectOverride(obj);
    }

    @Override
    public void defaultWriteObject() throws IOException {
        this.writeFields();
    }

    @Override
    public void writeFields() throws IOException {
        if (this.currentContainer != null) {
            this.currentContainer.writeMyself(this);
            this.currentContainer = null;
        } else {
            RegularObjectPersister.writeSlotWithFields(this.currentMetaClass, this.bout, this.currentObj, this.currentSubstitution);
        }
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    protected void writeStreamHeader() throws IOException {
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
    }

    @Override
    public void write(int val) throws IOException {
        this.bout.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.bout.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new SerializationException("buf can't be null");
        }
        this.bout.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.bout.flush();
    }

    @Override
    protected void drain() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.bout.close();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.bout.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.bout.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.bout.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.bout.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.bout.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.bout.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.bout.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.bout.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.bout.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.bout.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.bout.writeUTF(str);
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        this.currentContainer = new FieldsContainer(this.currentMetaClass);
        return this.currentContainer.createPut();
    }
}

