/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaDataSlot;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.BooleanContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.ByteContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.CharacterContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.DoubleContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.FinalContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.FloatContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.IntegerContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.LongContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.ShortContainer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;

public class FieldsContainer {
    ClassMetaDataSlot metaData;
    protected HashMap fields = new HashMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeField(ObjectOutput out, Map.Entry entry) throws IOException {
        out.writeUTF((String)entry.getKey());
        Object value = entry.getValue();
        if (value instanceof FinalContainer) {
            if (value instanceof BooleanContainer) {
                out.writeByte(12);
                out.writeBoolean(((BooleanContainer)value).getValue());
                return;
            } else if (value instanceof ByteContainer) {
                out.writeByte(9);
                out.writeByte(((ByteContainer)value).getValue());
                return;
            } else if (value instanceof CharacterContainer) {
                out.writeByte(11);
                out.writeChar(((CharacterContainer)value).getValue());
                return;
            } else if (value instanceof DoubleContainer) {
                out.writeByte(5);
                out.writeDouble(((DoubleContainer)value).getValue());
                return;
            } else if (value instanceof FloatContainer) {
                out.writeByte(10);
                out.writeFloat(((FloatContainer)value).getValue());
                return;
            } else if (value instanceof IntegerContainer) {
                out.writeByte(6);
                out.writeInt(((IntegerContainer)value).getValue());
                return;
            } else if (value instanceof LongContainer) {
                out.writeByte(7);
                out.writeLong(((LongContainer)value).getValue());
                return;
            } else {
                if (!(value instanceof ShortContainer)) throw new RuntimeException("Unexpected datatype " + value.getClass().getName());
                out.writeByte(8);
                out.writeShort(((ShortContainer)value).getValue());
            }
            return;
        } else {
            out.writeByte(3);
            out.writeObject(value);
        }
    }

    public void writeMyself(ObjectOutput output) throws IOException {
        output.writeInt(this.fields.size());
        for (Map.Entry entry : this.fields.entrySet()) {
            FieldsContainer.writeField(output, entry);
        }
    }

    public static Map.Entry readField(ObjectInput input) throws IOException, ClassNotFoundException {
        String name = input.readUTF();
        byte datatype = input.readByte();
        Object value = null;
        switch (datatype) {
            case 12: {
                value = BooleanContainer.valueOf(input.readBoolean());
                break;
            }
            case 9: {
                value = new ByteContainer(input.readByte());
                break;
            }
            case 11: {
                value = new CharacterContainer(input.readChar());
                break;
            }
            case 5: {
                value = new DoubleContainer(input.readDouble());
                break;
            }
            case 10: {
                value = new FloatContainer(input.readFloat());
                break;
            }
            case 6: {
                value = new IntegerContainer(input.readInt());
                break;
            }
            case 7: {
                value = new LongContainer(input.readLong());
                break;
            }
            case 8: {
                value = new ShortContainer(input.readShort());
                break;
            }
            case 3: {
                value = input.readObject();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected datatype " + datatype);
            }
        }
        return new EntryImpl(name, value);
    }

    public void readMyself(ObjectInput input) throws IOException, ClassNotFoundException {
        this.fields.clear();
        int numberOfFields = input.readInt();
        for (int i = 0; i < numberOfFields; ++i) {
            Map.Entry entry = FieldsContainer.readField(input);
            this.setField((String)entry.getKey(), entry.getValue());
        }
    }

    protected void setField(String name, Object value) {
        this.fields.put(name, value);
    }

    public FieldsContainer(ClassMetaDataSlot metaData) {
        this.metaData = metaData;
    }

    public ObjectInputStream.GetField createGet() {
        return new GetFieldImpl();
    }

    public ObjectOutputStream.PutField createPut() {
        return new PutFieldImpl();
    }

    class PutFieldImpl
    extends ObjectOutputStream.PutField {
        PutFieldImpl() {
        }

        @Override
        public void put(String name, boolean val) {
            FieldsContainer.this.setField(name, new Boolean(val));
        }

        @Override
        public void put(String name, byte val) {
            FieldsContainer.this.setField(name, new Byte(val));
        }

        @Override
        public void put(String name, char val) {
            FieldsContainer.this.setField(name, new Character(val));
        }

        @Override
        public void put(String name, short val) {
            FieldsContainer.this.setField(name, new Short(val));
        }

        @Override
        public void put(String name, int val) {
            FieldsContainer.this.setField(name, new Integer(val));
        }

        @Override
        public void put(String name, long val) {
            FieldsContainer.this.setField(name, new Long(val));
        }

        @Override
        public void put(String name, float val) {
            FieldsContainer.this.setField(name, new Float(val));
        }

        @Override
        public void put(String name, double val) {
            FieldsContainer.this.setField(name, new Double(val));
        }

        @Override
        public void put(String name, Object val) {
            FieldsContainer.this.setField(name, val);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            FieldsContainer.this.writeMyself(out);
        }
    }

    class GetFieldImpl
    extends ObjectInputStream.GetField {
        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return ObjectStreamClass.lookup(FieldsContainer.this.metaData.getSlotClass());
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return FieldsContainer.this.fields.get(name) == null;
        }

        @Override
        public boolean get(String name, boolean val) throws IOException {
            Boolean ret = (Boolean)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public byte get(String name, byte val) throws IOException {
            Byte ret = (Byte)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public char get(String name, char val) throws IOException {
            Character ret = (Character)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret.charValue();
        }

        @Override
        public short get(String name, short val) throws IOException {
            Short ret = (Short)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public int get(String name, int val) throws IOException {
            Integer ret = (Integer)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public long get(String name, long val) throws IOException {
            Long ret = (Long)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public float get(String name, float val) throws IOException {
            Float ret = (Float)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret.floatValue();
        }

        @Override
        public double get(String name, double val) throws IOException {
            Double ret = (Double)FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }

        @Override
        public Object get(String name, Object val) throws IOException {
            Object ret = FieldsContainer.this.fields.get(name);
            if (ret == null) {
                return val;
            }
            return ret;
        }
    }

    public static class EntryImpl
    implements Map.Entry {
        private Object key;
        private Object value;

        public EntryImpl(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new RuntimeException("method not supported");
        }
    }
}

