/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetamodelFactory;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassResolver;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.DefaultClassDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.BooleanContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.ByteContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.CharacterContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.DoubleContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.FloatContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.IntegerContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.LongContainer;
import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.ShortContainer;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DataContainerConstants;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DataExport;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DefaultObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectDescriptorFactory;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectsCache;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import com.ovea.jetty.session.serializer.jboss.serial.util.StringUtil;
import com.ovea.jetty.session.serializer.jboss.serial.util.StringUtilBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

public class DataContainer
extends DataExport
implements DataContainerConstants,
Externalizable {
    byte[] controlStreaming;
    DataContainerOutput currentOutput = null;
    ArrayList content = new ArrayList();
    transient ObjectsCache cache;

    public DataContainer cloneContainer() {
        DataContainer newContainer = new DataContainer();
        newContainer.content = this.content;
        newContainer.controlStreaming = this.controlStreaming;
        newContainer.cache = this.cache.cloneCache();
        return newContainer;
    }

    private DataContainer() {
    }

    public DataContainer(boolean checkSerializable) {
        this((ClassLoader)null, checkSerializable, null);
    }

    public DataContainer(boolean checkSerializable, StringUtilBuffer buffer) {
        this((ClassLoader)null, checkSerializable, buffer);
    }

    public DataContainer(ClassLoader loader, boolean checkSerializable, StringUtilBuffer buffer) {
        this(loader, null, checkSerializable, buffer);
    }

    public DataContainer(ClassLoader loader, boolean checkSerializable, StringUtilBuffer buffer, ClassResolver resolver) {
        this(loader, null, checkSerializable, buffer);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable) {
        this(loader, substitution, null, checkSerializable, null);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable, StringUtilBuffer buffer) {
        this(loader, substitution, null, checkSerializable, buffer);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, boolean checkSerializable, StringUtilBuffer buffer, ClassDescriptorStrategy classDescriptorStrategy, ObjectDescriptorStrategy objectDescriptorStrategy) {
        this(loader, substitution, null, checkSerializable, buffer, classDescriptorStrategy, objectDescriptorStrategy);
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable) {
        this();
        this.cache = new ObjectsCache(substitution, loader, safeToReuse, checkSerializable, null, new DefaultClassDescriptorStrategy(), new DefaultObjectDescriptorStrategy());
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable, StringUtilBuffer buffer) {
        this();
        this.cache = new ObjectsCache(substitution, loader, safeToReuse, checkSerializable, buffer, new DefaultClassDescriptorStrategy(), new DefaultObjectDescriptorStrategy());
    }

    public DataContainer(ClassLoader loader, ObjectSubstitutionInterface substitution, SafeCloningRepository safeToReuse, boolean checkSerializable, StringUtilBuffer buffer, ClassDescriptorStrategy classDescriptorStrategy, ObjectDescriptorStrategy objectDescriptorStrategy) {
        this();
        this.cache = new ObjectsCache(substitution, loader, safeToReuse, checkSerializable, buffer, classDescriptorStrategy, objectDescriptorStrategy);
    }

    public DataContainer(ObjectsCache cache) {
        this.cache = cache;
    }

    public int getSize() {
        return this.content.size();
    }

    public ObjectInput getInput() {
        return new DataContainerInput();
    }

    public ObjectOutput getOutput() {
        if (this.currentOutput == null) {
            this.currentOutput = new DataContainerOutput();
        }
        return this.currentOutput;
    }

    public ObjectOutput getDirectOutput(DataOutputStream dataOut) {
        return new DataContainerDirectOutput(dataOut);
    }

    public ObjectInput getDirectInput(DataInputStream dataInput) {
        return new DataContainerDirectInput(dataInput);
    }

    public void flush() throws IOException {
        if (this.currentOutput != null) {
            this.currentOutput.flushByteArray();
        }
    }

    public ObjectsCache getCache() {
        return this.cache;
    }

    public void saveData(DataOutput output) throws IOException {
        this.flush();
        output.writeInt(this.getControlStreaming().length);
        output.write(this.getControlStreaming());
        this.writeMyself(output);
        output.write(DataContainerConstants.closeSign);
    }

    private void writeInteger(DataOutput output, Object obj) throws IOException {
        if (obj instanceof IntegerContainer) {
            output.writeByte(6);
            output.writeInt(((IntegerContainer)obj).getValue());
        } else {
            output.writeByte(26);
            output.writeInt((Integer)obj);
        }
    }

    private void writeDouble(DataOutput output, Object obj) throws IOException {
        if (obj instanceof DoubleContainer) {
            output.writeByte(5);
            output.writeDouble(((DoubleContainer)obj).getValue());
        } else {
            output.writeByte(25);
            output.writeDouble((Double)obj);
        }
    }

    private void saveString(DataOutput output, Object obj) throws IOException {
        output.writeByte(4);
        StringUtil.saveString(output, (String)obj, this.cache.getStringBuffer());
    }

    public void loadData(DataInput input) throws IOException {
        int size = input.readInt();
        byte[] byteControl = new byte[size];
        input.readFully(byteControl);
        this.setControlStreaming(byteControl);
        this.readMyself(input);
    }

    private boolean compareBuffer(byte[] buffer1, byte[] buffer2) {
        for (int i = 0; i < buffer1.length; ++i) {
            if (buffer1[i] == buffer2[i]) continue;
            return false;
        }
        return true;
    }

    public void writeMyself(DataOutput output) throws IOException {
        if (this.currentOutput != null && this.currentOutput.outByte != null) {
            this.currentOutput.flushByteArray();
        }
        output.writeInt(this.content.size());
        for (Object obj : this.content) {
            if (obj == null) {
                output.writeByte(99);
                continue;
            }
            if (obj instanceof String) {
                this.saveString(output, obj);
                continue;
            }
            if (obj instanceof ByteContainer || obj instanceof Byte) {
                this.writeByte(output, obj);
                continue;
            }
            if (obj instanceof CharacterContainer || obj instanceof Character) {
                this.writeCharacter(output, obj);
                continue;
            }
            if (obj instanceof ShortContainer || obj instanceof Short) {
                this.writeShort(output, obj);
                continue;
            }
            if (obj instanceof IntegerContainer || obj instanceof Integer) {
                this.writeInteger(output, obj);
                continue;
            }
            if (obj instanceof LongContainer || obj instanceof Long) {
                this.writeLong(output, obj);
                continue;
            }
            if (obj instanceof DoubleContainer || obj instanceof Double) {
                this.writeDouble(output, obj);
                continue;
            }
            if (obj instanceof FloatContainer || obj instanceof Float) {
                this.writeFloat(output, obj);
                continue;
            }
            if (obj instanceof BooleanContainer || obj instanceof Boolean) {
                this.writeBoolean(output, obj);
                continue;
            }
            if (obj instanceof byte[]) {
                this.writeByteArray(output, obj);
                continue;
            }
            throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
        }
    }

    private void writeFloat(DataOutput output, Object obj) throws IOException {
        if (obj instanceof FloatContainer) {
            output.writeByte(10);
            output.writeFloat(((FloatContainer)obj).getValue());
        } else {
            output.writeByte(30);
            output.writeFloat(((Float)obj).floatValue());
        }
    }

    private void writeByteArray(DataOutput output, Object obj) throws IOException {
        output.writeByte(13);
        output.writeInt(((byte[])obj).length);
        output.write((byte[])obj);
    }

    private void writeBoolean(DataOutput output, Object obj) throws IOException {
        if (obj instanceof BooleanContainer) {
            output.writeByte(12);
            output.writeBoolean(((BooleanContainer)obj).getValue());
        } else {
            output.writeByte(32);
            output.writeBoolean((Boolean)obj);
        }
    }

    private void writeLong(DataOutput output, Object obj) throws IOException {
        if (obj instanceof LongContainer) {
            output.writeByte(7);
            output.writeLong(((LongContainer)obj).getValue());
        } else {
            output.writeByte(27);
            output.writeLong((Long)obj);
        }
    }

    private void writeShort(DataOutput output, Object obj) throws IOException {
        if (obj instanceof ShortContainer) {
            output.writeByte(8);
            output.writeShort(((ShortContainer)obj).getValue());
        } else {
            output.writeByte(28);
            output.writeShort(((Short)obj).shortValue());
        }
    }

    private void writeCharacter(DataOutput output, Object obj) throws IOException {
        if (obj instanceof Character) {
            output.writeByte(31);
            output.writeChar(((Character)obj).charValue());
        } else {
            output.writeByte(11);
            output.writeChar(((CharacterContainer)obj).getValue());
        }
    }

    private void writeByte(DataOutput output, Object obj) throws IOException {
        if (obj instanceof ByteContainer) {
            output.writeByte(9);
            output.writeByte(((ByteContainer)obj).getValue());
        } else {
            output.writeByte(29);
            output.writeByte(((Byte)obj).byteValue());
        }
    }

    public void readMyself(DataInput input) throws IOException {
        int size = input.readInt();
        this.content.clear();
        block21: for (int i = 0; i < size; ++i) {
            byte type = input.readByte();
            switch (type) {
                case 99: {
                    this.content.add(null);
                    continue block21;
                }
                case 4: {
                    this.content.add(StringUtil.readString(input, this.cache.getStringBuffer()));
                    continue block21;
                }
                case 9: {
                    this.content.add(new ByteContainer(input.readByte()));
                    continue block21;
                }
                case 29: {
                    this.content.add(new Byte(input.readByte()));
                    continue block21;
                }
                case 8: {
                    this.content.add(new ShortContainer(input.readShort()));
                    continue block21;
                }
                case 28: {
                    this.content.add(new Short(input.readShort()));
                    continue block21;
                }
                case 6: {
                    this.content.add(new IntegerContainer(input.readInt()));
                    continue block21;
                }
                case 26: {
                    this.content.add(new Integer(input.readInt()));
                    continue block21;
                }
                case 7: {
                    this.content.add(new LongContainer(input.readLong()));
                    continue block21;
                }
                case 27: {
                    this.content.add(new Long(input.readLong()));
                    continue block21;
                }
                case 10: {
                    this.content.add(new FloatContainer(input.readFloat()));
                    continue block21;
                }
                case 30: {
                    this.content.add(new Float(input.readFloat()));
                    continue block21;
                }
                case 5: {
                    this.content.add(new DoubleContainer(input.readDouble()));
                    continue block21;
                }
                case 25: {
                    this.content.add(new Double(input.readDouble()));
                    continue block21;
                }
                case 11: {
                    this.content.add(new CharacterContainer(input.readChar()));
                    continue block21;
                }
                case 31: {
                    this.content.add(new Character(input.readChar()));
                    continue block21;
                }
                case 12: {
                    this.content.add(BooleanContainer.valueOf(input.readBoolean()));
                    continue block21;
                }
                case 32: {
                    this.content.add(input.readBoolean());
                    continue block21;
                }
                case 13: {
                    int sizebArray = input.readInt();
                    byte[] barray = new byte[sizebArray];
                    input.readFully(barray);
                    this.content.add(barray);
                    continue block21;
                }
                default: {
                    throw new SerializationException("I don't know how to read type " + type + " yet");
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.saveData(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.loadData(in);
    }

    public byte[] getControlStreaming() {
        if (this.controlStreaming == null) {
            this.controlStreaming = new byte[0];
        }
        return this.controlStreaming;
    }

    public void setControlStreaming(byte[] controlStreaming) {
        this.controlStreaming = controlStreaming;
    }

    public ClassResolver getClassResolver() {
        return this.cache.getClassResolver();
    }

    public void setClassResolver(ClassResolver resolver) {
        this.cache.setClassResolver(resolver);
    }

    public StringUtilBuffer getStringBuffer() {
        return this.cache.getStringBuffer();
    }

    public void setStringBuffer(StringUtilBuffer stringBuffer) {
        this.cache.setStringBuffer(stringBuffer);
    }

    class DataContainerInput
    implements ObjectsCache.JBossSeralizationInputInterface {
        int position = -1;
        Object currentObject = null;
        ByteArrayInputStream byteStreamInput;

        public DataContainerInput() {
            this.byteStreamInput = new ByteArrayInputStream(DataContainer.this.getControlStreaming());
        }

        public void reset() {
            this.position = -1;
            this.byteStreamInput = null;
        }

        boolean moveNext() throws EOFException {
            ++this.position;
            int size = DataContainer.this.content.size();
            if (this.position >= size) {
                throw new EOFException("Unexpected end of repository");
            }
            this.currentObject = DataContainer.this.content.get(this.position);
            return this.position < size;
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            DataContainer.this.cache.setInput(this);
            return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, this);
        }

        @Override
        public int readObjectReference() throws IOException {
            this.moveNext();
            return ((IntegerContainer)this.currentObject).getValue();
        }

        @Override
        public byte readByteDirectly() throws IOException {
            return this.readByte();
        }

        @Override
        public int read() throws IOException {
            return this.byteStreamInput.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.byteStreamInput.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.byteStreamInput.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.byteStreamInput.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.byteStreamInput.available();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.byteStreamInput.read(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.byteStreamInput.read(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return (int)this.byteStreamInput.skip(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            this.moveNext();
            try {
                return ((BooleanContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be boolean", e);
            }
        }

        @Override
        public byte readByte() throws IOException {
            return (byte)this.byteStreamInput.read();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.byteStreamInput.read();
        }

        @Override
        public short readShort() throws IOException {
            this.moveNext();
            try {
                return ((ShortContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be short", e);
            }
        }

        @Override
        public int readUnsignedShort() throws IOException {
            this.moveNext();
            try {
                return ((ShortContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be short", e);
            }
        }

        @Override
        public char readChar() throws IOException {
            this.moveNext();
            try {
                return ((CharacterContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be char", e);
            }
        }

        @Override
        public int readInt() throws IOException {
            this.moveNext();
            try {
                return ((IntegerContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be int", e);
            }
        }

        @Override
        public long readLong() throws IOException {
            this.moveNext();
            try {
                return ((LongContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be long", e);
            }
        }

        @Override
        public float readFloat() throws IOException {
            this.moveNext();
            try {
                return ((FloatContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be float", e);
            }
        }

        @Override
        public double readDouble() throws IOException {
            this.moveNext();
            try {
                return ((DoubleContainer)this.currentObject).getValue();
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be double", e);
            }
        }

        @Override
        public String readLine() throws IOException {
            return this.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            this.moveNext();
            try {
                return (String)this.currentObject;
            }
            catch (ClassCastException e) {
                throw new SerializationException("Excepted to be String", e);
            }
        }

        @Override
        public Object readImmutable(byte byteDescription, ObjectsCache cache) throws IOException {
            this.moveNext();
            return this.currentObject;
        }
    }

    class DataContainerDirectInput
    implements ObjectsCache.JBossSeralizationInputInterface {
        DataInputStream dataInp;

        public DataContainerDirectInput(DataInputStream dataInp) {
            this.dataInp = dataInp;
        }

        @Override
        public int readObjectReference() throws IOException {
            return this.readInt();
        }

        @Override
        public byte readByteDirectly() throws IOException {
            return (byte)this.read();
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            DataContainer.this.cache.setInput(this);
            return ObjectDescriptorFactory.objectFromDescription(DataContainer.this.cache, this);
        }

        @Override
        public int read() throws IOException {
            return this.dataInp.read();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.dataInp.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.dataInp.available();
        }

        @Override
        public void close() throws IOException {
            this.dataInp.close();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.dataInp.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.dataInp.read(b, off, len);
        }

        @Override
        public void readFully(byte[] b) throws IOException {
            this.dataInp.readFully(b);
        }

        @Override
        public void readFully(byte[] b, int off, int len) throws IOException {
            this.dataInp.readFully(b, off, len);
        }

        @Override
        public int skipBytes(int n) throws IOException {
            return this.dataInp.skipBytes(n);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.dataInp.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.dataInp.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.dataInp.readUnsignedByte();
        }

        @Override
        public short readShort() throws IOException {
            return this.dataInp.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.dataInp.readUnsignedShort();
        }

        @Override
        public char readChar() throws IOException {
            return this.dataInp.readChar();
        }

        @Override
        public int readInt() throws IOException {
            return this.dataInp.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.dataInp.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.dataInp.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.dataInp.readDouble();
        }

        @Override
        public String readLine() throws IOException {
            return this.dataInp.readLine();
        }

        @Override
        public String readUTF() throws IOException {
            return StringUtil.readString(this.dataInp, DataContainer.this.cache.getStringBuffer());
        }

        public String readUTF(DataInput in) throws IOException {
            return StringUtil.readString(in, DataContainer.this.cache.getStringBuffer());
        }

        @Override
        public Object readImmutable(byte byteDescription, ObjectsCache cache) throws IOException {
            Object retObject = null;
            int reference = this.readObjectReference();
            switch (byteDescription) {
                case 40: {
                    retObject = cache.findObjectInCacheRead(reference);
                    if (retObject != null) break;
                    throw new IOException("reference " + reference + " not found no readImmutable");
                }
                case 4: {
                    retObject = StringUtil.readString(this, cache.getStringBuffer());
                    break;
                }
                case 9: {
                    retObject = new Byte(this.readByte());
                    break;
                }
                case 11: {
                    retObject = new Character(this.readChar());
                    break;
                }
                case 8: {
                    retObject = new Short(this.readShort());
                    break;
                }
                case 6: {
                    retObject = new Integer(this.readInt());
                    break;
                }
                case 7: {
                    retObject = new Long(this.readLong());
                    break;
                }
                case 5: {
                    retObject = new Double(this.readDouble());
                    break;
                }
                case 10: {
                    retObject = new Float(this.readFloat());
                    break;
                }
                case 12: {
                    retObject = new Boolean(this.readBoolean());
                }
            }
            if (byteDescription != 40) {
                cache.putObjectInCacheRead(reference, retObject);
            }
            return retObject;
        }
    }

    class DataContainerOutput
    implements ObjectsCache.JBossSeralizationOutputInterface {
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();

        DataContainerOutput() {
        }

        private void flushByteArray() {
            if (this.outByte != null) {
                byte[] controlStreaming = this.outByte.toByteArray();
                DataContainer.this.setControlStreaming(controlStreaming);
            }
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            if (obj == null) {
                this.writeByte(99);
            } else {
                if (ClassMetamodelFactory.isImmutable(obj.getClass()) && DataContainer.this.cache.getSubstitution() != null) {
                    obj = DataContainer.this.cache.getSubstitution().replaceObject(obj);
                }
                DataContainer.this.cache.setOutput(this);
                ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj);
            }
        }

        @Override
        public void addObjectReference(int reference) throws IOException {
            this.writeInt(reference);
        }

        @Override
        public void saveImmutable(ObjectsCache cache, Object obj) throws IOException {
            if (obj instanceof String) {
                this.writeByte(4);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Byte) {
                this.writeByte(9);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Character) {
                this.writeByte(11);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Short) {
                this.writeByte(8);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Integer) {
                this.writeByte(6);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Long) {
                this.writeByte(7);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Double) {
                this.writeByte(5);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof Float) {
                this.writeByte(10);
                DataContainer.this.content.add(obj);
            } else if (obj instanceof BooleanContainer || obj instanceof Boolean) {
                this.writeByte(12);
                DataContainer.this.content.add(obj);
            } else {
                throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
            }
        }

        @Override
        public void writeByteDirectly(byte parameter) throws IOException {
            this.writeByte(parameter);
        }

        @Override
        public void openObjectDefinition() throws IOException {
        }

        @Override
        public void closeObjectDefinition() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            this.outByte.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outByte.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outByte.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.flushByteArray();
        }

        @Override
        public void close() throws IOException {
            this.flush();
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            DataContainer.this.content.add(BooleanContainer.valueOf(v));
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.outByte.write(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            DataContainer.this.content.add(new ShortContainer((short)v));
        }

        @Override
        public void writeChar(int v) throws IOException {
            DataContainer.this.content.add(new CharacterContainer((char)v));
        }

        @Override
        public void writeInt(int v) throws IOException {
            DataContainer.this.content.add(new IntegerContainer(v));
        }

        @Override
        public void writeLong(long v) throws IOException {
            DataContainer.this.content.add(new LongContainer(v));
        }

        @Override
        public void writeFloat(float v) throws IOException {
            DataContainer.this.content.add(new FloatContainer(v));
        }

        @Override
        public void writeDouble(double v) throws IOException {
            DataContainer.this.content.add(new DoubleContainer(v));
        }

        @Override
        public void writeBytes(String s) throws IOException {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.write(chars[i]);
            }
        }

        @Override
        public void writeChars(String s) throws IOException {
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                this.writeChar(chars[i]);
            }
        }

        @Override
        public void writeUTF(String str) throws IOException {
            DataContainer.this.content.add(str);
        }

        @Override
        public boolean isCheckSerializableClass() {
            return DataContainer.this.cache.isCheckSerializableClass();
        }
    }

    class DataContainerDirectOutput
    implements ObjectsCache.JBossSeralizationOutputInterface {
        DataOutputStream dataOut;

        @Override
        public void addObjectReference(int reference) throws IOException {
            this.writeInt(reference);
        }

        @Override
        public void openObjectDefinition() throws IOException {
        }

        @Override
        public void closeObjectDefinition() throws IOException {
        }

        @Override
        public void writeByteDirectly(byte parameter) throws IOException {
            this.write(parameter);
        }

        @Override
        public boolean isCheckSerializableClass() {
            return DataContainer.this.getCache().isCheckSerializableClass();
        }

        @Override
        public void writeObject(Object obj) throws IOException {
            DataContainer.this.cache.setOutput(this);
            if (DataContainer.this.cache.getSubstitution() != null) {
                obj = DataContainer.this.cache.getSubstitution().replaceObject(obj);
            }
            ObjectDescriptorFactory.describeObject(DataContainer.this.cache, obj);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.dataOut.write(b);
        }

        @Override
        public void close() throws IOException {
            this.dataOut.close();
        }

        public DataContainerDirectOutput(DataOutputStream dataOut) {
            this.dataOut = dataOut;
        }

        @Override
        public void write(int b) throws IOException {
            this.dataOut.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.dataOut.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.dataOut.flush();
        }

        @Override
        public void writeBoolean(boolean v) throws IOException {
            this.dataOut.writeBoolean(v);
        }

        @Override
        public void writeByte(int v) throws IOException {
            this.dataOut.writeByte(v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.dataOut.writeShort(v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.dataOut.writeChar(v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.dataOut.writeInt(v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.dataOut.writeLong(v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.dataOut.writeFloat(v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.dataOut.writeDouble(v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.dataOut.writeBytes(s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.dataOut.writeChars(s);
        }

        @Override
        public void writeUTF(String str) throws IOException {
            StringUtil.saveString(this.dataOut, str, DataContainer.this.cache.getStringBuffer());
        }

        public int size() {
            return this.dataOut.size();
        }

        @Override
        public void saveImmutable(ObjectsCache cache, Object obj) throws IOException {
            int id = cache.findIdInCacheWrite(obj, true);
            if (id != 0) {
                this.writeByte(40);
                this.addObjectReference(id);
                return;
            }
            id = cache.putObjectInCacheWrite(obj, true);
            if (obj instanceof String) {
                this.writeByte(4);
                this.addObjectReference(id);
                StringUtil.saveString(this, (String)obj, cache.getStringBuffer());
            } else if (obj instanceof Byte) {
                this.writeByte(9);
                this.addObjectReference(id);
                this.writeByte(((Byte)obj).byteValue());
            } else if (obj instanceof Character) {
                this.writeByte(11);
                this.addObjectReference(id);
                this.writeChar(((Character)obj).charValue());
            } else if (obj instanceof Short) {
                this.writeByte(8);
                this.addObjectReference(id);
                this.writeShort(((Short)obj).shortValue());
            } else if (obj instanceof Integer) {
                this.writeByte(6);
                this.addObjectReference(id);
                this.writeInt((Integer)obj);
            } else if (obj instanceof Long) {
                this.writeByte(7);
                this.addObjectReference(id);
                this.writeLong((Long)obj);
            } else if (obj instanceof Double) {
                this.writeByte(5);
                this.addObjectReference(id);
                this.writeDouble((Double)obj);
            } else if (obj instanceof Float) {
                this.writeByte(10);
                this.addObjectReference(id);
                this.writeFloat(((Float)obj).floatValue());
            } else if (obj instanceof BooleanContainer || obj instanceof Boolean) {
                this.writeByte(12);
                this.addObjectReference(id);
                this.writeBoolean((Boolean)obj);
            } else {
                throw new SerializationException("I don't know how to write type " + obj.getClass().getName() + " yet");
            }
        }
    }
}

