/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.classmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ConstructorManager;
import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import sun.reflect.ReflectionFactory;

public class SunConstructorManager
extends ConstructorManager {
    static boolean supported = true;
    static ReflectionFactory reflectionFactory;

    @Override
    public Constructor getConstructor(Class clazz) throws SecurityException, NoSuchMethodException {
        if (clazz.isInterface()) {
            throw new NoSuchMethodException("Can't create a constructor for a pure interface");
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            Constructor constr = clazz.getDeclaredConstructor(EMPTY_CLASS_ARRY);
            constr.setAccessible(true);
            return constr;
        }
        if (Externalizable.class.isAssignableFrom(clazz)) {
            Constructor constr = clazz.getConstructor(EMPTY_CLASS_ARRY);
            constr.setAccessible(true);
            return constr;
        }
        Class currentClass = clazz;
        while (Serializable.class.isAssignableFrom(currentClass)) {
            currentClass = currentClass.getSuperclass();
        }
        Constructor constr = currentClass.getDeclaredConstructor(EMPTY_CLASS_ARRY);
        constr.setAccessible(true);
        Constructor<?> newConstructor = reflectionFactory.newConstructorForSerialization(clazz, constr);
        newConstructor.setAccessible(true);
        return newConstructor;
    }

    @Override
    public boolean isSupported() {
        return supported;
    }

    static {
        try {
            reflectionFactory = ReflectionFactory.getReflectionFactory();
        }
        catch (Throwable e) {
            e.printStackTrace();
            supported = false;
        }
    }
}

