/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.classmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaData;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassResolver;
import com.ovea.jetty.session.serializer.jboss.serial.util.ClassMetaConsts;
import com.ovea.jetty.session.serializer.jboss.serial.util.FastHashMap;
import com.ovea.jetty.session.serializer.jboss.serial.util.PartitionedWeakHashMap;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ClassMetamodelFactory
implements ClassMetaConsts {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    static Method methodLookup;
    static Method methodGetField;
    private static Map systemClassLoaderMap;
    static ThreadLocal cacheLoader;
    static PartitionedWeakHashMap cache;
    static ClassMetaData proxyMetaData;

    private static ObjectStreamClass lookup(Class clazz) throws IllegalAccessException, InvocationTargetException {
        return (ObjectStreamClass)methodLookup.invoke(null, clazz, Boolean.TRUE);
    }

    private static Field getField(Object source) throws IllegalAccessException, InvocationTargetException {
        return (Field)methodGetField.invoke(source, EMPTY_OBJECT_ARRAY);
    }

    public static void clear(boolean elimiteClassLoadersCached) {
        for (Map map : cache.values()) {
            map.clear();
        }
        if (elimiteClassLoadersCached) {
            cache.clear();
        }
        systemClassLoaderMap.clear();
    }

    public static void clear() {
        ClassMetamodelFactory.clear(true);
    }

    public static Map getCache() {
        return cache;
    }

    private static Map getLoaderMap(ClassLoader loader) {
        if (loader == null) {
            return systemClassLoaderMap;
        }
        CacheLoaderReference loaderReference = (CacheLoaderReference)cacheLoader.get();
        if (loaderReference == null) {
            loaderReference = new CacheLoaderReference();
            cacheLoader.set(loaderReference);
        }
        if (loaderReference.getCurrentClassLoader() == loader) {
            return loaderReference.getCurrentMap();
        }
        Map hashMap = (Map)cache.get(loader);
        Object returnLoader = null;
        if (hashMap == null) {
            hashMap = new FastHashMap();
            cache.put(loader, hashMap);
            hashMap = (Map)cache.get(loader);
        }
        loaderReference.setCurrentClassLoader(loader);
        loaderReference.setCurrentMap(hashMap);
        return hashMap;
    }

    private static ClassMetaData getClassMetaData(String clazzName, ClassLoader loader, boolean checkSerializable) throws IOException {
        return ClassMetamodelFactory.getClassMetaData(clazzName, null, loader, checkSerializable);
    }

    private static Class resolveClassByName(String clazzName, ClassResolver resolver, ClassLoader loader) throws ClassNotFoundException {
        Class clazz = (Class)primClasses.get(clazzName);
        if (clazz == null) {
            if (resolver != null) {
                clazz = resolver.resolveClass(clazzName);
                if (clazz == null) {
                    clazz = Class.forName(clazzName, false, loader);
                }
            } else {
                clazz = Class.forName(clazzName, false, loader);
            }
        }
        return clazz;
    }

    public static ClassMetaData getClassMetaData(String clazzName, ClassResolver resolver, ClassLoader loader, boolean checkSerializable) throws IOException {
        try {
            Class clazz;
            Map loaderMap = ClassMetamodelFactory.getLoaderMap(loader);
            ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazzName);
            if (classMetadata == null) {
                clazz = ClassMetamodelFactory.resolveClassByName(clazzName, resolver, loader);
                if (checkSerializable && !Serializable.class.isAssignableFrom(clazz)) {
                    throw new NotSerializableException(clazz.getName());
                }
                classMetadata = new ClassMetaData(clazz);
                loaderMap = ClassMetamodelFactory.getLoaderMap(loader);
                loaderMap.put(clazzName, classMetadata);
                classMetadata = (ClassMetaData)loaderMap.get(clazzName);
            }
            if (classMetadata.getClazz() == null) {
                clazz = ClassMetamodelFactory.resolveClassByName(clazzName, resolver, loader);
                loaderMap.remove(clazzName);
                classMetadata = new ClassMetaData(clazz);
                loaderMap.put(clazz.getName(), classMetadata);
                classMetadata = (ClassMetaData)loaderMap.get(clazzName);
            }
            if (classMetadata.isProxy()) {
                return proxyMetaData;
            }
            return classMetadata;
        }
        catch (ClassNotFoundException e) {
            IOException ex = new IOException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    public static ClassMetaData getClassMetaData(Class clazz, boolean checkSerializable) throws IOException {
        if (checkSerializable && !Serializable.class.isAssignableFrom(clazz) && !clazz.isPrimitive()) {
            throw new NotSerializableException(clazz.getName());
        }
        Map loaderMap = ClassMetamodelFactory.getLoaderMap(clazz.getClassLoader());
        ClassMetaData classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
        if (classMetadata == null) {
            classMetadata = new ClassMetaData(clazz);
            loaderMap.put(clazz.getName(), classMetadata);
            classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
        }
        if (classMetadata.getClazz() == null) {
            loaderMap.remove(clazz.getName());
            classMetadata = new ClassMetaData(clazz);
            loaderMap.put(clazz.getName(), classMetadata);
            classMetadata = (ClassMetaData)loaderMap.get(clazz.getName());
        }
        if (classMetadata.isProxy()) {
            return proxyMetaData;
        }
        return classMetadata;
    }

    public static boolean isImmutable(Class clazz) {
        return clazz == Character.class || clazz == String.class || clazz == Long.class || clazz == Byte.class || clazz == Double.class || clazz == Float.class || clazz == Integer.class || clazz == Short.class || clazz == Boolean.class || clazz.isPrimitive();
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        primClasses.put("[Z", boolean[].class);
        primClasses.put("[B", byte[].class);
        primClasses.put("[C", char[].class);
        primClasses.put("[S", short[].class);
        primClasses.put("[I", int[].class);
        primClasses.put("[J", long[].class);
        primClasses.put("[F", float[].class);
        primClasses.put("[D", double[].class);
        systemClassLoaderMap = new FastHashMap();
        cacheLoader = new ThreadLocal();
        try {
            methodLookup = ObjectStreamClass.class.getDeclaredMethod("lookup", Class.class, Boolean.TYPE);
            methodLookup.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            methodGetField = ObjectStreamField.class.getDeclaredMethod("getField", new Class[0]);
            methodGetField.setAccessible(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        cache = new PartitionedWeakHashMap();
        proxyMetaData = null;
        try {
            proxyMetaData = ClassMetamodelFactory.getClassMetaData("java.lang.reflect.Proxy", Thread.currentThread().getContextClassLoader(), true);
            proxyMetaData.setProxy(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class CacheLoaderReference {
        WeakReference currentClassLoader;
        Map currentHashMap;

        private CacheLoaderReference() {
        }

        public ClassLoader getCurrentClassLoader() {
            if (this.currentClassLoader == null) {
                return null;
            }
            return (ClassLoader)this.currentClassLoader.get();
        }

        public void setCurrentClassLoader(ClassLoader loader) {
            this.currentClassLoader = new WeakReference<ClassLoader>(loader);
        }

        public Map getCurrentMap() {
            return this.currentHashMap;
        }

        public void setCurrentMap(Map currentMap) {
            this.currentHashMap = currentMap;
        }
    }
}

