/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer;

import com.ovea.jetty.session.SerializerException;
import com.ovea.jetty.session.serializer.SerializerSkeleton;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.XmlHeaderAwareReader;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyReplacer;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public final class XStreamSerializer
extends SerializerSkeleton {
    private XStream xStream;

    @Override
    public void start() {
        this.xStream = new XStream((HierarchicalStreamDriver)new AbstractXmlDriver(new XmlFriendlyReplacer()){

            public HierarchicalStreamReader createReader(Reader in) {
                return new XppReader(in, this.xmlFriendlyReplacer());
            }

            public HierarchicalStreamReader createReader(InputStream in) {
                try {
                    return this.createReader((Reader)new XmlHeaderAwareReader(in));
                }
                catch (UnsupportedEncodingException e) {
                    throw new StreamException((Throwable)e);
                }
                catch (IOException e) {
                    throw new StreamException((Throwable)e);
                }
            }

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new CompactWriter(out, this.xmlFriendlyReplacer());
            }

            public HierarchicalStreamWriter createWriter(OutputStream out) {
                return this.createWriter(new OutputStreamWriter(out));
            }
        });
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.xStream = null;
    }

    @Override
    public String serialize(Object o) throws SerializerException {
        return this.xStream.toXML(o);
    }

    @Override
    public <T> T deserialize(String o, Class<T> targetType) throws SerializerException {
        return targetType.cast(this.xStream.fromXML(o));
    }
}

