/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer;

import com.ovea.jetty.session.SerializerException;
import com.ovea.jetty.session.serializer.SerializerSkeleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.jetty.util.B64Code;

public abstract class BinarySerializer
extends SerializerSkeleton {
    private boolean gzip = true;

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    @Override
    public final String serialize(Object o) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (this.gzip) {
                GZIPOutputStream gout = new GZIPOutputStream(baos);
                this.write(gout, o);
                gout.finish();
                gout.close();
            } else {
                this.write(baos, o);
            }
            return String.valueOf(B64Code.encode((byte[])baos.toByteArray(), (boolean)false));
        }
        catch (Exception e) {
            throw new SerializerException("Error serializing " + o + " : " + e.getMessage(), e);
        }
    }

    @Override
    public final <T> T deserialize(String o, Class<T> targetType) throws SerializerException {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(B64Code.decode((String)o));
            return targetType.cast(this.read(this.gzip ? new GZIPInputStream(bais) : bais));
        }
        catch (Exception e) {
            throw new SerializerException("Error deserializing " + o + " : " + e.getMessage(), e);
        }
    }

    protected abstract void write(OutputStream var1, Object var2) throws Exception;

    protected abstract Object read(InputStream var1) throws Exception;
}

