/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.redis;

import com.ovea.jetty.session.SessionIdManagerSkeleton;
import com.ovea.jetty.session.redis.JedisCallback;
import com.ovea.jetty.session.redis.JedisExecutor;
import com.ovea.jetty.session.redis.PooledJedisExecutor;
import java.util.LinkedList;
import java.util.List;
import javax.naming.InitialContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.exceptions.JedisException;

public final class RedisSessionIdManager
extends SessionIdManagerSkeleton {
    static final Logger LOG = Log.getLogger((String)"com.ovea.jetty.session");
    private static final Long ZERO = 0L;
    private static final String REDIS_SESSIONS_KEY = "jetty-sessions";
    static final String REDIS_SESSION_KEY = "jetty-session-";
    private final JedisExecutor jedisExecutor;

    public RedisSessionIdManager(Server server, JedisPool jedisPool) {
        super(server);
        this.jedisExecutor = new PooledJedisExecutor(jedisPool);
    }

    public RedisSessionIdManager(Server server, final String jndiName) {
        super(server);
        this.jedisExecutor = new JedisExecutor(){
            JedisExecutor delegate;

            @Override
            public <V> V execute(JedisCallback<V> cb) {
                if (this.delegate == null) {
                    try {
                        InitialContext ic = new InitialContext();
                        JedisPool jedisPool = (JedisPool)ic.lookup(jndiName);
                        this.delegate = new PooledJedisExecutor(jedisPool);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Unable to find instance of " + JedisExecutor.class.getName() + " in JNDI location " + jndiName + " : " + e.getMessage(), e);
                    }
                }
                return this.delegate.execute(cb);
            }
        };
    }

    @Override
    protected void deleteClusterId(final String clusterId) {
        this.jedisExecutor.execute(new JedisCallback<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return jedis.srem(RedisSessionIdManager.REDIS_SESSIONS_KEY, clusterId);
            }
        });
    }

    @Override
    protected void storeClusterId(final String clusterId) {
        this.jedisExecutor.execute(new JedisCallback<Object>(){

            @Override
            public Object execute(Jedis jedis) {
                return jedis.sadd(RedisSessionIdManager.REDIS_SESSIONS_KEY, clusterId);
            }
        });
    }

    @Override
    protected boolean hasClusterId(final String clusterId) {
        return this.jedisExecutor.execute(new JedisCallback<Boolean>(){

            @Override
            public Boolean execute(Jedis jedis) {
                return jedis.sismember(RedisSessionIdManager.REDIS_SESSIONS_KEY, clusterId);
            }
        });
    }

    @Override
    protected List<String> scavenge(final List<String> clusterIds) {
        LinkedList<String> expired = new LinkedList<String>();
        List<Object> status = this.jedisExecutor.execute(new JedisCallback<List<Object>>(){

            @Override
            public List<Object> execute(Jedis jedis) {
                return jedis.multi(new TransactionBlock(){

                    public void execute() throws JedisException {
                        for (String clusterId : clusterIds) {
                            this.exists(RedisSessionIdManager.REDIS_SESSION_KEY + clusterId);
                        }
                    }
                });
            }
        });
        for (int i = 0; i < status.size(); ++i) {
            if (!ZERO.equals(status.get(i))) continue;
            expired.add(clusterIds.get(i));
        }
        if (LOG.isDebugEnabled() && !expired.isEmpty()) {
            LOG.debug("[RedisSessionIdManager] Scavenger found {} sessions to expire: {}", new Object[]{expired.size(), expired});
        }
        return expired;
    }
}

