/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.redis;

import com.ovea.jetty.session.redis.JedisCallback;
import com.ovea.jetty.session.redis.JedisExecutor;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisException;

class PooledJedisExecutor
implements JedisExecutor {
    private final JedisPool jedisPool;

    PooledJedisExecutor(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public <V> V execute(JedisCallback<V> cb) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            V v = cb.execute(jedis);
            return v;
        }
        catch (JedisException e) {
            this.jedisPool.returnBrokenResource((Object)jedis);
            throw e;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }
}

