/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.server.session.AbstractSession;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SessionManagerSkeleton<T extends SessionSkeleton>
extends AbstractSessionManager {
    private static final Logger LOG = Log.getLogger((String)"com.ovea.jetty.session");
    private static final Field _cookieSet;
    private final ConcurrentMap<String, T> sessions = new ConcurrentHashMap<String, T>();

    public void doStart() throws Exception {
        this.sessions.clear();
        super.doStart();
    }

    public void doStop() throws Exception {
        this.sessions.clear();
        super.doStop();
    }

    protected final void addSession(AbstractSession session) {
        if (this.isRunning()) {
            SessionSkeleton sessionSkeleton = (SessionSkeleton)session;
            String clusterId = this.getClusterId((HttpSession)session);
            this.sessions.put(clusterId, (T)((Object)sessionSkeleton));
            sessionSkeleton.willPassivate();
            this.storeSession(sessionSkeleton);
            sessionSkeleton.didActivate();
        }
    }

    public final void removeSession(AbstractSession sess, boolean invalidate) {
        SessionSkeleton session = (SessionSkeleton)sess;
        String clusterId = this.getClusterId((HttpSession)session);
        boolean removed = this.removeSession(clusterId);
        if (removed) {
            this._sessionsStats.decrement();
            this._sessionTimeStats.set(Math.round((double)(System.currentTimeMillis() - session.getCreationTime()) / 1000.0));
            this._sessionIdManager.removeSession((HttpSession)session);
            if (invalidate) {
                this._sessionIdManager.invalidateAll(session.getClusterId());
            }
            if (invalidate && this._sessionListeners != null) {
                HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                int i = LazyList.size((Object)this._sessionListeners);
                while (i-- > 0) {
                    ((HttpSessionListener)LazyList.get((Object)this._sessionListeners, (int)i)).sessionDestroyed(event);
                }
            }
            if (!invalidate) {
                session.willPassivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean removeSession(String clusterId) {
        SessionManagerSkeleton sessionManagerSkeleton = this;
        synchronized (sessionManagerSkeleton) {
            SessionSkeleton session = (SessionSkeleton)((Object)this.sessions.remove(clusterId));
            try {
                if (session != null) {
                    this.deleteSession(session);
                }
            }
            catch (Exception e) {
                LOG.warn("Problem deleting session id=" + clusterId, (Throwable)e);
            }
            return session != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final SessionSkeleton getSession(String clusterId) {
        ConcurrentMap<String, T> concurrentMap = this.sessions;
        synchronized (concurrentMap) {
            SessionSkeleton current = (SessionSkeleton)((Object)this.sessions.get(clusterId));
            SessionSkeleton loaded = this.loadSession(clusterId, current);
            if (loaded != null) {
                this.sessions.put(clusterId, (T)((Object)loaded));
                if (current != loaded) {
                    loaded.didActivate();
                }
            }
            return loaded;
        }
    }

    @Deprecated
    public final Map getSessionMap() {
        return Collections.unmodifiableMap(this.sessions);
    }

    protected final void invalidateSessions() {
    }

    public final void invalidateSession(String clusterId) {
        AbstractSession session = (AbstractSession)this.sessions.get(clusterId);
        if (session != null) {
            session.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expire(List<String> expired) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        try {
            for (String expiredClusterId : expired) {
                LOG.debug("[SessionManagerSkeleton] Expiring session id={}", new Object[]{expiredClusterId});
                SessionSkeleton session = (SessionSkeleton)((Object)this.sessions.get(expiredClusterId));
                if (session == null) continue;
                session.timeout();
            }
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            LOG.warn("Problem expiring sessions", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    public final void setSessionPath(String path) {
        this.getSessionCookieConfig().setPath(path);
    }

    public final void setMaxCookieAge(int seconds) {
        this.getSessionCookieConfig().setMaxAge(seconds);
    }

    public void setSessionDomain(String domain) {
        this.setDomain(domain);
    }

    public void setDomain(String domain) {
        this.getSessionCookieConfig().setDomain(domain);
    }

    protected final String getVirtualHost() {
        String vhost = "0.0.0.0";
        if (this._context == null) {
            return vhost;
        }
        String[] vhosts = this._context.getContextHandler().getVirtualHosts();
        if (vhosts == null || vhosts.length == 0 || vhosts[0] == null) {
            return vhost;
        }
        return vhosts[0];
    }

    protected final String getCanonicalizedContext() {
        if (this._context.getContextPath() == null) {
            return "";
        }
        return this._context.getContextPath().replace('/', '_').replace('.', '_').replace('\\', '_');
    }

    protected abstract void storeSession(T var1);

    protected abstract void deleteSession(T var1);

    protected abstract T loadSession(String var1, T var2);

    static {
        try {
            _cookieSet = AbstractSession.class.getDeclaredField("_cookieSet");
            _cookieSet.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public abstract class SessionSkeleton
    extends AbstractSession {
        public SessionSkeleton(HttpServletRequest request) {
            super((AbstractSessionManager)SessionManagerSkeleton.this, request);
            super.setMaxInactiveInterval(SessionManagerSkeleton.this._dftMaxIdleSecs > 0 ? SessionManagerSkeleton.this._dftMaxIdleSecs : -1);
        }

        public SessionSkeleton(long created, long accessed, String clusterId) {
            super((AbstractSessionManager)SessionManagerSkeleton.this, created, accessed, clusterId);
        }

        public void timeout() throws IllegalStateException {
            LOG.debug("Timing out session id={}", new Object[]{this.getClusterId()});
            super.timeout();
        }

        protected void setCookieSetTime(long time) {
            try {
                _cookieSet.set((Object)this, time);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

