/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oda.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetOdaInstanceRequest
extends BmcRequest<Void> {
    private String odaInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"odaInstanceId", "opcRequestId"})
    GetOdaInstanceRequest(String odaInstanceId, String opcRequestId) {
        this.odaInstanceId = odaInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOdaInstanceId() {
        return this.odaInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOdaInstanceRequest, Void> {
        private String odaInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOdaInstanceRequest o) {
            this.odaInstanceId(o.getOdaInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOdaInstanceRequest build() {
            GetOdaInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder odaInstanceId(String odaInstanceId) {
            this.odaInstanceId = odaInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetOdaInstanceRequest buildWithoutInvocationCallback() {
            return new GetOdaInstanceRequest(this.odaInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetOdaInstanceRequest.Builder(odaInstanceId=" + this.odaInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

