/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.oce.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetOceInstanceRequest
extends BmcRequest<Void> {
    private String oceInstanceId;
    private String opcRequestId;

    @ConstructorProperties(value={"oceInstanceId", "opcRequestId"})
    GetOceInstanceRequest(String oceInstanceId, String opcRequestId) {
        this.oceInstanceId = oceInstanceId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOceInstanceId() {
        return this.oceInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetOceInstanceRequest, Void> {
        private String oceInstanceId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetOceInstanceRequest o) {
            this.oceInstanceId(o.getOceInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetOceInstanceRequest build() {
            GetOceInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder oceInstanceId(String oceInstanceId) {
            this.oceInstanceId = oceInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetOceInstanceRequest buildWithoutInvocationCallback() {
            return new GetOceInstanceRequest(this.oceInstanceId, this.opcRequestId);
        }

        public String toString() {
            return "GetOceInstanceRequest.Builder(oceInstanceId=" + this.oceInstanceId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

