/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.dns.model.SteeringPolicySummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSteeringPoliciesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private Long limit;
    private String page;
    private String id;
    private String displayName;
    private String displayNameContains;
    private String healthCheckMonitorId;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;
    private String template;
    private SteeringPolicySummary.LifecycleState lifecycleState;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private Scope scope;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "limit", "page", "id", "displayName", "displayNameContains", "healthCheckMonitorId", "timeCreatedGreaterThanOrEqualTo", "timeCreatedLessThan", "template", "lifecycleState", "sortBy", "sortOrder", "scope"})
    ListSteeringPoliciesRequest(String compartmentId, String opcRequestId, Long limit, String page, String id, String displayName, String displayNameContains, String healthCheckMonitorId, Date timeCreatedGreaterThanOrEqualTo, Date timeCreatedLessThan, String template, SteeringPolicySummary.LifecycleState lifecycleState, SortBy sortBy, SortOrder sortOrder, Scope scope) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.limit = limit;
        this.page = page;
        this.id = id;
        this.displayName = displayName;
        this.displayNameContains = displayNameContains;
        this.healthCheckMonitorId = healthCheckMonitorId;
        this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
        this.timeCreatedLessThan = timeCreatedLessThan;
        this.template = template;
        this.lifecycleState = lifecycleState;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.scope = scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Long getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameContains() {
        return this.displayNameContains;
    }

    public String getHealthCheckMonitorId() {
        return this.healthCheckMonitorId;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public String getTemplate() {
        return this.template;
    }

    public SteeringPolicySummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSteeringPoliciesRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private Long limit;
        private String page;
        private String id;
        private String displayName;
        private String displayNameContains;
        private String healthCheckMonitorId;
        private Date timeCreatedGreaterThanOrEqualTo;
        private Date timeCreatedLessThan;
        private String template;
        private SteeringPolicySummary.LifecycleState lifecycleState;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Scope scope;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSteeringPoliciesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.id(o.getId());
            this.displayName(o.getDisplayName());
            this.displayNameContains(o.getDisplayNameContains());
            this.healthCheckMonitorId(o.getHealthCheckMonitorId());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.template(o.getTemplate());
            this.lifecycleState(o.getLifecycleState());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.scope(o.getScope());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSteeringPoliciesRequest build() {
            ListSteeringPoliciesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameContains(String displayNameContains) {
            this.displayNameContains = displayNameContains;
            return this;
        }

        public Builder healthCheckMonitorId(String healthCheckMonitorId) {
            this.healthCheckMonitorId = healthCheckMonitorId;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder template(String template) {
            this.template = template;
            return this;
        }

        public Builder lifecycleState(SteeringPolicySummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public ListSteeringPoliciesRequest buildWithoutInvocationCallback() {
            return new ListSteeringPoliciesRequest(this.compartmentId, this.opcRequestId, this.limit, this.page, this.id, this.displayName, this.displayNameContains, this.healthCheckMonitorId, this.timeCreatedGreaterThanOrEqualTo, this.timeCreatedLessThan, this.template, this.lifecycleState, this.sortBy, this.sortOrder, this.scope);
        }

        public String toString() {
            return "ListSteeringPoliciesRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", limit=" + this.limit + ", page=" + this.page + ", id=" + this.id + ", displayName=" + this.displayName + ", displayNameContains=" + this.displayNameContains + ", healthCheckMonitorId=" + this.healthCheckMonitorId + ", timeCreatedGreaterThanOrEqualTo=" + this.timeCreatedGreaterThanOrEqualTo + ", timeCreatedLessThan=" + this.timeCreatedLessThan + ", template=" + this.template + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", scope=" + (Object)((Object)this.scope) + ")";
        }
    }

    public static enum SortBy {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        Template("template");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

