/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.dns.model.ResolverEndpointSummary;
import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.dns.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListResolverEndpointsRequest
extends BmcRequest<Void> {
    private String resolverId;
    private String opcRequestId;
    private String name;
    private String page;
    private Long limit;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private ResolverEndpointSummary.LifecycleState lifecycleState;
    private Scope scope;

    @ConstructorProperties(value={"resolverId", "opcRequestId", "name", "page", "limit", "sortOrder", "sortBy", "lifecycleState", "scope"})
    ListResolverEndpointsRequest(String resolverId, String opcRequestId, String name, String page, Long limit, SortOrder sortOrder, SortBy sortBy, ResolverEndpointSummary.LifecycleState lifecycleState, Scope scope) {
        this.resolverId = resolverId;
        this.opcRequestId = opcRequestId;
        this.name = name;
        this.page = page;
        this.limit = limit;
        this.sortOrder = sortOrder;
        this.sortBy = sortBy;
        this.lifecycleState = lifecycleState;
        this.scope = scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResolverId() {
        return this.resolverId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getName() {
        return this.name;
    }

    public String getPage() {
        return this.page;
    }

    public Long getLimit() {
        return this.limit;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public ResolverEndpointSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResolverEndpointsRequest, Void> {
        private String resolverId;
        private String opcRequestId;
        private String name;
        private String page;
        private Long limit;
        private SortOrder sortOrder;
        private SortBy sortBy;
        private ResolverEndpointSummary.LifecycleState lifecycleState;
        private Scope scope;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResolverEndpointsRequest o) {
            this.resolverId(o.getResolverId());
            this.opcRequestId(o.getOpcRequestId());
            this.name(o.getName());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.lifecycleState(o.getLifecycleState());
            this.scope(o.getScope());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResolverEndpointsRequest build() {
            ListResolverEndpointsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder lifecycleState(ResolverEndpointSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public ListResolverEndpointsRequest buildWithoutInvocationCallback() {
            return new ListResolverEndpointsRequest(this.resolverId, this.opcRequestId, this.name, this.page, this.limit, this.sortOrder, this.sortBy, this.lifecycleState, this.scope);
        }

        public String toString() {
            return "ListResolverEndpointsRequest.Builder(resolverId=" + this.resolverId + ", opcRequestId=" + this.opcRequestId + ", name=" + this.name + ", page=" + this.page + ", limit=" + this.limit + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", sortBy=" + (Object)((Object)this.sortBy) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", scope=" + (Object)((Object)this.scope) + ")";
        }
    }

    public static enum SortBy {
        Name("name"),
        TimeCreated("timeCreated");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

