/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetResolverEndpointRequest
extends BmcRequest<Void> {
    private String resolverId;
    private String resolverEndpointName;
    private String ifModifiedSince;
    private String ifNoneMatch;
    private String opcRequestId;
    private Scope scope;

    @ConstructorProperties(value={"resolverId", "resolverEndpointName", "ifModifiedSince", "ifNoneMatch", "opcRequestId", "scope"})
    GetResolverEndpointRequest(String resolverId, String resolverEndpointName, String ifModifiedSince, String ifNoneMatch, String opcRequestId, Scope scope) {
        this.resolverId = resolverId;
        this.resolverEndpointName = resolverEndpointName;
        this.ifModifiedSince = ifModifiedSince;
        this.ifNoneMatch = ifNoneMatch;
        this.opcRequestId = opcRequestId;
        this.scope = scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResolverId() {
        return this.resolverId;
    }

    public String getResolverEndpointName() {
        return this.resolverEndpointName;
    }

    public String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public String getIfNoneMatch() {
        return this.ifNoneMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    implements BmcRequest.Builder<GetResolverEndpointRequest, Void> {
        private String resolverId;
        private String resolverEndpointName;
        private String ifModifiedSince;
        private String ifNoneMatch;
        private String opcRequestId;
        private Scope scope;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetResolverEndpointRequest o) {
            this.resolverId(o.getResolverId());
            this.resolverEndpointName(o.getResolverEndpointName());
            this.ifModifiedSince(o.getIfModifiedSince());
            this.ifNoneMatch(o.getIfNoneMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetResolverEndpointRequest build() {
            GetResolverEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder resolverEndpointName(String resolverEndpointName) {
            this.resolverEndpointName = resolverEndpointName;
            return this;
        }

        public Builder ifModifiedSince(String ifModifiedSince) {
            this.ifModifiedSince = ifModifiedSince;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public GetResolverEndpointRequest buildWithoutInvocationCallback() {
            return new GetResolverEndpointRequest(this.resolverId, this.resolverEndpointName, this.ifModifiedSince, this.ifNoneMatch, this.opcRequestId, this.scope);
        }

        public String toString() {
            return "GetResolverEndpointRequest.Builder(resolverId=" + this.resolverId + ", resolverEndpointName=" + this.resolverEndpointName + ", ifModifiedSince=" + this.ifModifiedSince + ", ifNoneMatch=" + this.ifNoneMatch + ", opcRequestId=" + this.opcRequestId + ", scope=" + (Object)((Object)this.scope) + ")";
        }
    }
}

