/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteResolverEndpointRequest
extends BmcRequest<Void> {
    private String resolverId;
    private String resolverEndpointName;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;

    @ConstructorProperties(value={"resolverId", "resolverEndpointName", "ifMatch", "ifUnmodifiedSince", "opcRequestId", "scope"})
    DeleteResolverEndpointRequest(String resolverId, String resolverEndpointName, String ifMatch, String ifUnmodifiedSince, String opcRequestId, Scope scope) {
        this.resolverId = resolverId;
        this.resolverEndpointName = resolverEndpointName;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.opcRequestId = opcRequestId;
        this.scope = scope;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getResolverId() {
        return this.resolverId;
    }

    public String getResolverEndpointName() {
        return this.resolverEndpointName;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteResolverEndpointRequest, Void> {
        private String resolverId;
        private String resolverEndpointName;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String opcRequestId;
        private Scope scope;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteResolverEndpointRequest o) {
            this.resolverId(o.getResolverId());
            this.resolverEndpointName(o.getResolverEndpointName());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteResolverEndpointRequest build() {
            DeleteResolverEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder resolverId(String resolverId) {
            this.resolverId = resolverId;
            return this;
        }

        public Builder resolverEndpointName(String resolverEndpointName) {
            this.resolverEndpointName = resolverEndpointName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public DeleteResolverEndpointRequest buildWithoutInvocationCallback() {
            return new DeleteResolverEndpointRequest(this.resolverId, this.resolverEndpointName, this.ifMatch, this.ifUnmodifiedSince, this.opcRequestId, this.scope);
        }

        public String toString() {
            return "DeleteResolverEndpointRequest.Builder(resolverId=" + this.resolverId + ", resolverEndpointName=" + this.resolverEndpointName + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", opcRequestId=" + this.opcRequestId + ", scope=" + (Object)((Object)this.scope) + ")";
        }
    }
}

