/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RecordOperation {
    @JsonProperty(value="domain")
    private final String domain;
    @JsonProperty(value="recordHash")
    private final String recordHash;
    @JsonProperty(value="isProtected")
    private final Boolean isProtected;
    @JsonProperty(value="rdata")
    private final String rdata;
    @JsonProperty(value="rrsetVersion")
    private final String rrsetVersion;
    @JsonProperty(value="rtype")
    private final String rtype;
    @JsonProperty(value="ttl")
    private final Integer ttl;
    @JsonProperty(value="operation")
    private final Operation operation;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().domain(this.domain).recordHash(this.recordHash).isProtected(this.isProtected).rdata(this.rdata).rrsetVersion(this.rrsetVersion).rtype(this.rtype).ttl(this.ttl).operation(this.operation);
    }

    public String getDomain() {
        return this.domain;
    }

    public String getRecordHash() {
        return this.recordHash;
    }

    public Boolean getIsProtected() {
        return this.isProtected;
    }

    public String getRdata() {
        return this.rdata;
    }

    public String getRrsetVersion() {
        return this.rrsetVersion;
    }

    public String getRtype() {
        return this.rtype;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordOperation)) {
            return false;
        }
        RecordOperation other = (RecordOperation)o;
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$recordHash = this.getRecordHash();
        String other$recordHash = other.getRecordHash();
        if (this$recordHash == null ? other$recordHash != null : !this$recordHash.equals(other$recordHash)) {
            return false;
        }
        Boolean this$isProtected = this.getIsProtected();
        Boolean other$isProtected = other.getIsProtected();
        if (this$isProtected == null ? other$isProtected != null : !((Object)this$isProtected).equals(other$isProtected)) {
            return false;
        }
        String this$rdata = this.getRdata();
        String other$rdata = other.getRdata();
        if (this$rdata == null ? other$rdata != null : !this$rdata.equals(other$rdata)) {
            return false;
        }
        String this$rrsetVersion = this.getRrsetVersion();
        String other$rrsetVersion = other.getRrsetVersion();
        if (this$rrsetVersion == null ? other$rrsetVersion != null : !this$rrsetVersion.equals(other$rrsetVersion)) {
            return false;
        }
        String this$rtype = this.getRtype();
        String other$rtype = other.getRtype();
        if (this$rtype == null ? other$rtype != null : !this$rtype.equals(other$rtype)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $recordHash = this.getRecordHash();
        result = result * 59 + ($recordHash == null ? 43 : $recordHash.hashCode());
        Boolean $isProtected = this.getIsProtected();
        result = result * 59 + ($isProtected == null ? 43 : ((Object)$isProtected).hashCode());
        String $rdata = this.getRdata();
        result = result * 59 + ($rdata == null ? 43 : $rdata.hashCode());
        String $rrsetVersion = this.getRrsetVersion();
        result = result * 59 + ($rrsetVersion == null ? 43 : $rrsetVersion.hashCode());
        String $rtype = this.getRtype();
        result = result * 59 + ($rtype == null ? 43 : $rtype.hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "RecordOperation(domain=" + this.getDomain() + ", recordHash=" + this.getRecordHash() + ", isProtected=" + this.getIsProtected() + ", rdata=" + this.getRdata() + ", rrsetVersion=" + this.getRrsetVersion() + ", rtype=" + this.getRtype() + ", ttl=" + this.getTtl() + ", operation=" + (Object)((Object)this.getOperation()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"domain", "recordHash", "isProtected", "rdata", "rrsetVersion", "rtype", "ttl", "operation"})
    @Deprecated
    public RecordOperation(String domain, String recordHash, Boolean isProtected, String rdata, String rrsetVersion, String rtype, Integer ttl, Operation operation) {
        this.domain = domain;
        this.recordHash = recordHash;
        this.isProtected = isProtected;
        this.rdata = rdata;
        this.rrsetVersion = rrsetVersion;
        this.rtype = rtype;
        this.ttl = ttl;
        this.operation = operation;
    }

    public static enum Operation {
        Require("REQUIRE"),
        Prohibit("PROHIBIT"),
        Add("ADD"),
        Remove("REMOVE");

        private final String value;
        private static Map<String, Operation> map;

        private Operation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Operation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Operation: " + key);
        }

        static {
            map = new HashMap<String, Operation>();
            for (Operation v : Operation.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="domain")
        private String domain;
        @JsonProperty(value="recordHash")
        private String recordHash;
        @JsonProperty(value="isProtected")
        private Boolean isProtected;
        @JsonProperty(value="rdata")
        private String rdata;
        @JsonProperty(value="rrsetVersion")
        private String rrsetVersion;
        @JsonProperty(value="rtype")
        private String rtype;
        @JsonProperty(value="ttl")
        private Integer ttl;
        @JsonProperty(value="operation")
        private Operation operation;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder domain(String domain) {
            this.domain = domain;
            this.__explicitlySet__.add("domain");
            return this;
        }

        public Builder recordHash(String recordHash) {
            this.recordHash = recordHash;
            this.__explicitlySet__.add("recordHash");
            return this;
        }

        public Builder isProtected(Boolean isProtected) {
            this.isProtected = isProtected;
            this.__explicitlySet__.add("isProtected");
            return this;
        }

        public Builder rdata(String rdata) {
            this.rdata = rdata;
            this.__explicitlySet__.add("rdata");
            return this;
        }

        public Builder rrsetVersion(String rrsetVersion) {
            this.rrsetVersion = rrsetVersion;
            this.__explicitlySet__.add("rrsetVersion");
            return this;
        }

        public Builder rtype(String rtype) {
            this.rtype = rtype;
            this.__explicitlySet__.add("rtype");
            return this;
        }

        public Builder ttl(Integer ttl) {
            this.ttl = ttl;
            this.__explicitlySet__.add("ttl");
            return this;
        }

        public Builder operation(Operation operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public RecordOperation build() {
            RecordOperation __instance__ = new RecordOperation(this.domain, this.recordHash, this.isProtected, this.rdata, this.rrsetVersion, this.rtype, this.ttl, this.operation);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(RecordOperation o) {
            Builder copiedBuilder = this.domain(o.getDomain()).recordHash(o.getRecordHash()).isProtected(o.getIsProtected()).rdata(o.getRdata()).rrsetVersion(o.getRrsetVersion()).rtype(o.getRtype()).ttl(o.getTtl()).operation(o.getOperation());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "RecordOperation.Builder(domain=" + this.domain + ", recordHash=" + this.recordHash + ", isProtected=" + this.isProtected + ", rdata=" + this.rdata + ", rrsetVersion=" + this.rrsetVersion + ", rtype=" + this.rtype + ", ttl=" + this.ttl + ", operation=" + (Object)((Object)this.operation) + ")";
        }
    }
}

